// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisvideoarchivedmedia.paginators

import aws.sdk.kotlin.services.kinesisvideoarchivedmedia.KinesisVideoArchivedMediaClient
import aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.Fragment
import aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.GetImagesRequest
import aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.GetImagesResponse
import aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.Image
import aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.ListFragmentsRequest
import aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.ListFragmentsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [GetImagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetImagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetImagesResponse]
 */
public fun KinesisVideoArchivedMediaClient.getImagesPaginated(initialRequest: GetImagesRequest): Flow<GetImagesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getImagesPaginated.getImages(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetImagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetImagesResponse]
 */
public fun KinesisVideoArchivedMediaClient.getImagesPaginated(block: GetImagesRequest.Builder.() -> Unit): Flow<GetImagesResponse> =
    getImagesPaginated(GetImagesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getImagesPaginated]
 * to access the nested member [Image]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Image]
 */
@JvmName("getImagesResponseImage")
public fun Flow<GetImagesResponse>.images(): Flow<Image> =
    transform() { response ->
        response.images?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFragmentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFragmentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFragmentsResponse]
 */
public fun KinesisVideoArchivedMediaClient.listFragmentsPaginated(initialRequest: ListFragmentsRequest = ListFragmentsRequest { }): Flow<ListFragmentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFragmentsPaginated.listFragments(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFragmentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFragmentsResponse]
 */
public fun KinesisVideoArchivedMediaClient.listFragmentsPaginated(block: ListFragmentsRequest.Builder.() -> Unit): Flow<ListFragmentsResponse> =
    listFragmentsPaginated(ListFragmentsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFragmentsPaginated]
 * to access the nested member [Fragment]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Fragment]
 */
@JvmName("listFragmentsResponseFragment")
public fun Flow<ListFragmentsResponse>.fragments(): Flow<Fragment> =
    transform() { response ->
        response.fragments?.forEach {
            emit(it)
        }
    }
