// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetImagesRequest private constructor(builder: Builder) {
    /**
     * The end timestamp for the range of images to be generated. If the time range between `StartTimestamp` and `EndTimestamp` is more than 300 seconds above `StartTimestamp`, you will receive an `IllegalArgumentException`.
     */
    public val endTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.endTimestamp
    /**
     * The format that will be used to encode the image.
     */
    public val format: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.Format? = builder.format
    /**
     * The list of a key-value pair structure that contains extra parameters that can be applied when the image is generated. The `FormatConfig` key is the `JPEGQuality`, which indicates the JPEG quality key to be used to generate the image. The `FormatConfig` value accepts ints from 1 to 100. If the value is 1, the image will be generated with less quality and the best compression. If the value is 100, the image will be generated with the best quality and less compression. If no value is provided, the default value of the `JPEGQuality` key will be set to 80.
     */
    public val formatConfig: Map<String, String>? = builder.formatConfig
    /**
     * The height of the output image that is used in conjunction with the `WidthPixels` parameter. When both `HeightPixels` and `WidthPixels` parameters are provided, the image will be stretched to fit the specified aspect ratio. If only the `HeightPixels` parameter is provided, its original aspect ratio will be used to calculate the `WidthPixels` ratio. If neither parameter is provided, the original image size will be returned.
     */
    public val heightPixels: kotlin.Int? = builder.heightPixels
    /**
     * The origin of the Server or Producer timestamps to use to generate the images.
     */
    public val imageSelectorType: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.ImageSelectorType? = builder.imageSelectorType
    /**
     * The maximum number of images to be returned by the API.
     *
     * The default limit is 25 images per API response. Providing a `MaxResults` greater than this value will result in a page size of 25. Any additional results will be paginated.
     */
    public val maxResults: kotlin.Long? = builder.maxResults
    /**
     * A token that specifies where to start paginating the next set of Images. This is the `GetImages:NextToken` from a previously truncated response.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The time interval in milliseconds (ms) at which the images need to be generated from the stream. The minimum value that can be provided is 200 ms (5 images per second). If the timestamp range is less than the sampling interval, the image from the `startTimestamp` will be returned if available.
     */
    public val samplingInterval: kotlin.Int? = builder.samplingInterval
    /**
     * The starting point from which the images should be generated. This `StartTimestamp` must be within an inclusive range of timestamps for an image to be returned.
     */
    public val startTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.startTimestamp
    /**
     * The Amazon Resource Name (ARN) of the stream from which to retrieve the images. You must specify either the `StreamName` or the `StreamARN`.
     */
    public val streamArn: kotlin.String? = builder.streamArn
    /**
     * The name of the stream from which to retrieve the images. You must specify either the `StreamName` or the `StreamARN`.
     */
    public val streamName: kotlin.String? = builder.streamName
    /**
     * The width of the output image that is used in conjunction with the `HeightPixels` parameter. When both `WidthPixels` and `HeightPixels` parameters are provided, the image will be stretched to fit the specified aspect ratio. If only the `WidthPixels` parameter is provided or if only the `HeightPixels` is provided, a `ValidationException` will be thrown. If neither parameter is provided, the original image size from the stream will be returned.
     */
    public val widthPixels: kotlin.Int? = builder.widthPixels

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.GetImagesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetImagesRequest(")
        append("endTimestamp=$endTimestamp,")
        append("format=$format,")
        append("formatConfig=$formatConfig,")
        append("heightPixels=$heightPixels,")
        append("imageSelectorType=$imageSelectorType,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("samplingInterval=$samplingInterval,")
        append("startTimestamp=$startTimestamp,")
        append("streamArn=$streamArn,")
        append("streamName=$streamName,")
        append("widthPixels=$widthPixels")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTimestamp?.hashCode() ?: 0
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (formatConfig?.hashCode() ?: 0)
        result = 31 * result + (heightPixels ?: 0)
        result = 31 * result + (imageSelectorType?.hashCode() ?: 0)
        result = 31 * result + (maxResults?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (samplingInterval ?: 0)
        result = 31 * result + (startTimestamp?.hashCode() ?: 0)
        result = 31 * result + (streamArn?.hashCode() ?: 0)
        result = 31 * result + (streamName?.hashCode() ?: 0)
        result = 31 * result + (widthPixels ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetImagesRequest

        if (endTimestamp != other.endTimestamp) return false
        if (format != other.format) return false
        if (formatConfig != other.formatConfig) return false
        if (heightPixels != other.heightPixels) return false
        if (imageSelectorType != other.imageSelectorType) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (samplingInterval != other.samplingInterval) return false
        if (startTimestamp != other.startTimestamp) return false
        if (streamArn != other.streamArn) return false
        if (streamName != other.streamName) return false
        if (widthPixels != other.widthPixels) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.GetImagesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The end timestamp for the range of images to be generated. If the time range between `StartTimestamp` and `EndTimestamp` is more than 300 seconds above `StartTimestamp`, you will receive an `IllegalArgumentException`.
         */
        public var endTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The format that will be used to encode the image.
         */
        public var format: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.Format? = null
        /**
         * The list of a key-value pair structure that contains extra parameters that can be applied when the image is generated. The `FormatConfig` key is the `JPEGQuality`, which indicates the JPEG quality key to be used to generate the image. The `FormatConfig` value accepts ints from 1 to 100. If the value is 1, the image will be generated with less quality and the best compression. If the value is 100, the image will be generated with the best quality and less compression. If no value is provided, the default value of the `JPEGQuality` key will be set to 80.
         */
        public var formatConfig: Map<String, String>? = null
        /**
         * The height of the output image that is used in conjunction with the `WidthPixels` parameter. When both `HeightPixels` and `WidthPixels` parameters are provided, the image will be stretched to fit the specified aspect ratio. If only the `HeightPixels` parameter is provided, its original aspect ratio will be used to calculate the `WidthPixels` ratio. If neither parameter is provided, the original image size will be returned.
         */
        public var heightPixels: kotlin.Int? = null
        /**
         * The origin of the Server or Producer timestamps to use to generate the images.
         */
        public var imageSelectorType: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.ImageSelectorType? = null
        /**
         * The maximum number of images to be returned by the API.
         *
         * The default limit is 25 images per API response. Providing a `MaxResults` greater than this value will result in a page size of 25. Any additional results will be paginated.
         */
        public var maxResults: kotlin.Long? = null
        /**
         * A token that specifies where to start paginating the next set of Images. This is the `GetImages:NextToken` from a previously truncated response.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The time interval in milliseconds (ms) at which the images need to be generated from the stream. The minimum value that can be provided is 200 ms (5 images per second). If the timestamp range is less than the sampling interval, the image from the `startTimestamp` will be returned if available.
         */
        public var samplingInterval: kotlin.Int? = null
        /**
         * The starting point from which the images should be generated. This `StartTimestamp` must be within an inclusive range of timestamps for an image to be returned.
         */
        public var startTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the stream from which to retrieve the images. You must specify either the `StreamName` or the `StreamARN`.
         */
        public var streamArn: kotlin.String? = null
        /**
         * The name of the stream from which to retrieve the images. You must specify either the `StreamName` or the `StreamARN`.
         */
        public var streamName: kotlin.String? = null
        /**
         * The width of the output image that is used in conjunction with the `HeightPixels` parameter. When both `WidthPixels` and `HeightPixels` parameters are provided, the image will be stretched to fit the specified aspect ratio. If only the `WidthPixels` parameter is provided or if only the `HeightPixels` is provided, a `ValidationException` will be thrown. If neither parameter is provided, the original image size from the stream will be returned.
         */
        public var widthPixels: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.GetImagesRequest) : this() {
            this.endTimestamp = x.endTimestamp
            this.format = x.format
            this.formatConfig = x.formatConfig
            this.heightPixels = x.heightPixels
            this.imageSelectorType = x.imageSelectorType
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.samplingInterval = x.samplingInterval
            this.startTimestamp = x.startTimestamp
            this.streamArn = x.streamArn
            this.streamName = x.streamName
            this.widthPixels = x.widthPixels
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.GetImagesRequest = GetImagesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
