// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model



/**
 * Contains the range of timestamps for the requested media, and the source of the timestamps.
 */
public class HlsFragmentSelector private constructor(builder: Builder) {
    /**
     * The source of the timestamps for the requested media.
     *
     * When `FragmentSelectorType` is set to `PRODUCER_TIMESTAMP` and GetHLSStreamingSessionURLInput$PlaybackMode is `ON_DEMAND` or `LIVE_REPLAY`, the first fragment ingested with a producer timestamp within the specified FragmentSelector$TimestampRange is included in the media playlist. In addition, the fragments with producer timestamps within the `TimestampRange` ingested immediately following the first fragment (up to the GetHLSStreamingSessionURLInput$MaxMediaPlaylistFragmentResults value) are included.
     *
     * Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are producing a stream of fragments with producer timestamps that are approximately equal to the true clock time, the HLS media playlists will contain all of the fragments within the requested timestamp range. If some fragments are ingested within the same time range and very different points in time, only the oldest ingested collection of fragments are returned.
     *
     * When `FragmentSelectorType` is set to `PRODUCER_TIMESTAMP` and GetHLSStreamingSessionURLInput$PlaybackMode is `LIVE`, the producer timestamps are used in the MP4 fragments and for deduplication. But the most recently ingested fragments based on server timestamps are included in the HLS media playlist. This means that even if fragments ingested in the past have producer timestamps with values now, they are not included in the HLS media playlist.
     *
     * The default is `SERVER_TIMESTAMP`.
     */
    public val fragmentSelectorType: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.HlsFragmentSelectorType? = builder.fragmentSelectorType
    /**
     * The start and end of the timestamp range for the requested media.
     *
     * This value should not be present if `PlaybackType` is `LIVE`.
     */
    public val timestampRange: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.HlsTimestampRange? = builder.timestampRange

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.HlsFragmentSelector = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HlsFragmentSelector(")
        append("fragmentSelectorType=$fragmentSelectorType,")
        append("timestampRange=$timestampRange)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fragmentSelectorType?.hashCode() ?: 0
        result = 31 * result + (timestampRange?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HlsFragmentSelector

        if (fragmentSelectorType != other.fragmentSelectorType) return false
        if (timestampRange != other.timestampRange) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.HlsFragmentSelector = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The source of the timestamps for the requested media.
         *
         * When `FragmentSelectorType` is set to `PRODUCER_TIMESTAMP` and GetHLSStreamingSessionURLInput$PlaybackMode is `ON_DEMAND` or `LIVE_REPLAY`, the first fragment ingested with a producer timestamp within the specified FragmentSelector$TimestampRange is included in the media playlist. In addition, the fragments with producer timestamps within the `TimestampRange` ingested immediately following the first fragment (up to the GetHLSStreamingSessionURLInput$MaxMediaPlaylistFragmentResults value) are included.
         *
         * Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are producing a stream of fragments with producer timestamps that are approximately equal to the true clock time, the HLS media playlists will contain all of the fragments within the requested timestamp range. If some fragments are ingested within the same time range and very different points in time, only the oldest ingested collection of fragments are returned.
         *
         * When `FragmentSelectorType` is set to `PRODUCER_TIMESTAMP` and GetHLSStreamingSessionURLInput$PlaybackMode is `LIVE`, the producer timestamps are used in the MP4 fragments and for deduplication. But the most recently ingested fragments based on server timestamps are included in the HLS media playlist. This means that even if fragments ingested in the past have producer timestamps with values now, they are not included in the HLS media playlist.
         *
         * The default is `SERVER_TIMESTAMP`.
         */
        public var fragmentSelectorType: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.HlsFragmentSelectorType? = null
        /**
         * The start and end of the timestamp range for the requested media.
         *
         * This value should not be present if `PlaybackType` is `LIVE`.
         */
        public var timestampRange: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.HlsTimestampRange? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.HlsFragmentSelector) : this() {
            this.fragmentSelectorType = x.fragmentSelectorType
            this.timestampRange = x.timestampRange
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.HlsFragmentSelector = HlsFragmentSelector(this)

        /**
         * construct an [aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.HlsTimestampRange] inside the given [block]
         */
        public fun timestampRange(block: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.HlsTimestampRange.Builder.() -> kotlin.Unit) {
            this.timestampRange = aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.HlsTimestampRange.invoke(block)
        }
    }
}
