// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model



public class GetDashStreamingSessionUrlRequest private constructor(builder: Builder) {
    /**
     * The time range of the requested fragment and the source of the timestamps.
     *
     * This parameter is required if `PlaybackMode` is `ON_DEMAND` or `LIVE_REPLAY`. This parameter is optional if PlaybackMode is```LIVE`. If `PlaybackMode` is `LIVE`, the `FragmentSelectorType` can be set, but the `TimestampRange` should not be set. If `PlaybackMode` is `ON_DEMAND` or `LIVE_REPLAY`, both `FragmentSelectorType` and `TimestampRange` must be set.
     */
    public val dashFragmentSelector: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.DashFragmentSelector? = builder.dashFragmentSelector
    /**
     * Fragments are identified in the manifest file based on their sequence number in the session. If DisplayFragmentNumber is set to `ALWAYS`, the Kinesis Video Streams fragment number is added to each S element in the manifest file with the attribute name “kvs:fn”. These fragment numbers can be used for logging or for use with other APIs (e.g. `GetMedia` and `GetMediaForFragmentList`). A custom MPEG-DASH media player is necessary to leverage these this custom attribute.
     *
     * The default value is `NEVER`.
     */
    public val displayFragmentNumber: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.DashDisplayFragmentNumber? = builder.displayFragmentNumber
    /**
     * Per the MPEG-DASH specification, the wall-clock time of fragments in the manifest file can be derived using attributes in the manifest itself. However, typically, MPEG-DASH compatible media players do not properly handle gaps in the media timeline. Kinesis Video Streams adjusts the media timeline in the manifest file to enable playback of media with discontinuities. Therefore, the wall-clock time derived from the manifest file may be inaccurate. If DisplayFragmentTimestamp is set to `ALWAYS`, the accurate fragment timestamp is added to each S element in the manifest file with the attribute name “kvs:ts”. A custom MPEG-DASH media player is necessary to leverage this custom attribute.
     *
     * The default value is `NEVER`. When DASHFragmentSelector is `SERVER_TIMESTAMP`, the timestamps will be the server start timestamps. Similarly, when DASHFragmentSelector is `PRODUCER_TIMESTAMP`, the timestamps will be the producer start timestamps.
     */
    public val displayFragmentTimestamp: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.DashDisplayFragmentTimestamp? = builder.displayFragmentTimestamp
    /**
     * The time in seconds until the requested session expires. This value can be between 300 (5 minutes) and 43200 (12 hours).
     *
     * When a session expires, no new calls to `GetDashManifest`, `GetMP4InitFragment`, or `GetMP4MediaFragment` can be made for that session.
     *
     * The default is 300 (5 minutes).
     */
    public val expires: kotlin.Int? = builder.expires
    /**
     * The maximum number of fragments that are returned in the MPEG-DASH manifest.
     *
     * When the `PlaybackMode` is `LIVE`, the most recent fragments are returned up to this value. When the `PlaybackMode` is `ON_DEMAND`, the oldest fragments are returned, up to this maximum number.
     *
     * When there are a higher number of fragments available in a live MPEG-DASH manifest, video players often buffer content before starting playback. Increasing the buffer size increases the playback latency, but it decreases the likelihood that rebuffering will occur during playback. We recommend that a live MPEG-DASH manifest have a minimum of 3 fragments and a maximum of 10 fragments.
     *
     * The default is 5 fragments if `PlaybackMode` is `LIVE` or `LIVE_REPLAY`, and 1,000 if `PlaybackMode` is `ON_DEMAND`.
     *
     * The maximum value of 1,000 fragments corresponds to more than 16 minutes of video on streams with 1-second fragments, and more than 2 1/2 hours of video on streams with 10-second fragments.
     */
    public val maxManifestFragmentResults: kotlin.Long? = builder.maxManifestFragmentResults
    /**
     * Whether to retrieve live, live replay, or archived, on-demand data.
     *
     * Features of the three types of sessions include the following:
     * + **`LIVE`**: For sessions of this type, the MPEG-DASH manifest is continually updated with the latest fragments as they become available. We recommend that the media player retrieve a new manifest on a one-second interval. When this type of session is played in a media player, the user interface typically displays a "live" notification, with no scrubber control for choosing the position in the playback window to display.In `LIVE` mode, the newest available fragments are included in an MPEG-DASH manifest, even if there is a gap between fragments (that is, if a fragment is missing). A gap like this might cause a media player to halt or cause a jump in playback. In this mode, fragments are not added to the MPEG-DASH manifest if they are older than the newest fragment in the playlist. If the missing fragment becomes available after a subsequent fragment is added to the manifest, the older fragment is not added, and the gap is not filled.
     * + **`LIVE_REPLAY`**: For sessions of this type, the MPEG-DASH manifest is updated similarly to how it is updated for `LIVE` mode except that it starts by including fragments from a given start time. Instead of fragments being added as they are ingested, fragments are added as the duration of the next fragment elapses. For example, if the fragments in the session are two seconds long, then a new fragment is added to the manifest every two seconds. This mode is useful to be able to start playback from when an event is detected and continue live streaming media that has not yet been ingested as of the time of the session creation. This mode is also useful to stream previously archived media without being limited by the 1,000 fragment limit in the `ON_DEMAND` mode.
     * + **`ON_DEMAND`**: For sessions of this type, the MPEG-DASH manifest contains all the fragments for the session, up to the number that is specified in `MaxManifestFragmentResults`. The manifest must be retrieved only once for each session. When this type of session is played in a media player, the user interface typically displays a scrubber control for choosing the position in the playback window to display.
     *
     * In all playback modes, if `FragmentSelectorType` is `PRODUCER_TIMESTAMP`, and if there are multiple fragments with the same start timestamp, the fragment that has the larger fragment number (that is, the newer fragment) is included in the MPEG-DASH manifest. The other fragments are not included. Fragments that have different timestamps but have overlapping durations are still included in the MPEG-DASH manifest. This can lead to unexpected behavior in the media player.
     *
     * The default is `LIVE`.
     */
    public val playbackMode: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.DashPlaybackMode? = builder.playbackMode
    /**
     * The Amazon Resource Name (ARN) of the stream for which to retrieve the MPEG-DASH manifest URL.
     *
     * You must specify either the `StreamName` or the `StreamARN`.
     */
    public val streamArn: kotlin.String? = builder.streamArn
    /**
     * The name of the stream for which to retrieve the MPEG-DASH manifest URL.
     *
     * You must specify either the `StreamName` or the `StreamARN`.
     */
    public val streamName: kotlin.String? = builder.streamName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetDashStreamingSessionUrlRequest(")
        append("dashFragmentSelector=$dashFragmentSelector,")
        append("displayFragmentNumber=$displayFragmentNumber,")
        append("displayFragmentTimestamp=$displayFragmentTimestamp,")
        append("expires=$expires,")
        append("maxManifestFragmentResults=$maxManifestFragmentResults,")
        append("playbackMode=$playbackMode,")
        append("streamArn=$streamArn,")
        append("streamName=$streamName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dashFragmentSelector?.hashCode() ?: 0
        result = 31 * result + (displayFragmentNumber?.hashCode() ?: 0)
        result = 31 * result + (displayFragmentTimestamp?.hashCode() ?: 0)
        result = 31 * result + (expires ?: 0)
        result = 31 * result + (maxManifestFragmentResults?.hashCode() ?: 0)
        result = 31 * result + (playbackMode?.hashCode() ?: 0)
        result = 31 * result + (streamArn?.hashCode() ?: 0)
        result = 31 * result + (streamName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetDashStreamingSessionUrlRequest

        if (dashFragmentSelector != other.dashFragmentSelector) return false
        if (displayFragmentNumber != other.displayFragmentNumber) return false
        if (displayFragmentTimestamp != other.displayFragmentTimestamp) return false
        if (expires != other.expires) return false
        if (maxManifestFragmentResults != other.maxManifestFragmentResults) return false
        if (playbackMode != other.playbackMode) return false
        if (streamArn != other.streamArn) return false
        if (streamName != other.streamName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time range of the requested fragment and the source of the timestamps.
         *
         * This parameter is required if `PlaybackMode` is `ON_DEMAND` or `LIVE_REPLAY`. This parameter is optional if PlaybackMode is```LIVE`. If `PlaybackMode` is `LIVE`, the `FragmentSelectorType` can be set, but the `TimestampRange` should not be set. If `PlaybackMode` is `ON_DEMAND` or `LIVE_REPLAY`, both `FragmentSelectorType` and `TimestampRange` must be set.
         */
        public var dashFragmentSelector: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.DashFragmentSelector? = null
        /**
         * Fragments are identified in the manifest file based on their sequence number in the session. If DisplayFragmentNumber is set to `ALWAYS`, the Kinesis Video Streams fragment number is added to each S element in the manifest file with the attribute name “kvs:fn”. These fragment numbers can be used for logging or for use with other APIs (e.g. `GetMedia` and `GetMediaForFragmentList`). A custom MPEG-DASH media player is necessary to leverage these this custom attribute.
         *
         * The default value is `NEVER`.
         */
        public var displayFragmentNumber: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.DashDisplayFragmentNumber? = null
        /**
         * Per the MPEG-DASH specification, the wall-clock time of fragments in the manifest file can be derived using attributes in the manifest itself. However, typically, MPEG-DASH compatible media players do not properly handle gaps in the media timeline. Kinesis Video Streams adjusts the media timeline in the manifest file to enable playback of media with discontinuities. Therefore, the wall-clock time derived from the manifest file may be inaccurate. If DisplayFragmentTimestamp is set to `ALWAYS`, the accurate fragment timestamp is added to each S element in the manifest file with the attribute name “kvs:ts”. A custom MPEG-DASH media player is necessary to leverage this custom attribute.
         *
         * The default value is `NEVER`. When DASHFragmentSelector is `SERVER_TIMESTAMP`, the timestamps will be the server start timestamps. Similarly, when DASHFragmentSelector is `PRODUCER_TIMESTAMP`, the timestamps will be the producer start timestamps.
         */
        public var displayFragmentTimestamp: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.DashDisplayFragmentTimestamp? = null
        /**
         * The time in seconds until the requested session expires. This value can be between 300 (5 minutes) and 43200 (12 hours).
         *
         * When a session expires, no new calls to `GetDashManifest`, `GetMP4InitFragment`, or `GetMP4MediaFragment` can be made for that session.
         *
         * The default is 300 (5 minutes).
         */
        public var expires: kotlin.Int? = null
        /**
         * The maximum number of fragments that are returned in the MPEG-DASH manifest.
         *
         * When the `PlaybackMode` is `LIVE`, the most recent fragments are returned up to this value. When the `PlaybackMode` is `ON_DEMAND`, the oldest fragments are returned, up to this maximum number.
         *
         * When there are a higher number of fragments available in a live MPEG-DASH manifest, video players often buffer content before starting playback. Increasing the buffer size increases the playback latency, but it decreases the likelihood that rebuffering will occur during playback. We recommend that a live MPEG-DASH manifest have a minimum of 3 fragments and a maximum of 10 fragments.
         *
         * The default is 5 fragments if `PlaybackMode` is `LIVE` or `LIVE_REPLAY`, and 1,000 if `PlaybackMode` is `ON_DEMAND`.
         *
         * The maximum value of 1,000 fragments corresponds to more than 16 minutes of video on streams with 1-second fragments, and more than 2 1/2 hours of video on streams with 10-second fragments.
         */
        public var maxManifestFragmentResults: kotlin.Long? = null
        /**
         * Whether to retrieve live, live replay, or archived, on-demand data.
         *
         * Features of the three types of sessions include the following:
         * + **`LIVE`**: For sessions of this type, the MPEG-DASH manifest is continually updated with the latest fragments as they become available. We recommend that the media player retrieve a new manifest on a one-second interval. When this type of session is played in a media player, the user interface typically displays a "live" notification, with no scrubber control for choosing the position in the playback window to display.In `LIVE` mode, the newest available fragments are included in an MPEG-DASH manifest, even if there is a gap between fragments (that is, if a fragment is missing). A gap like this might cause a media player to halt or cause a jump in playback. In this mode, fragments are not added to the MPEG-DASH manifest if they are older than the newest fragment in the playlist. If the missing fragment becomes available after a subsequent fragment is added to the manifest, the older fragment is not added, and the gap is not filled.
         * + **`LIVE_REPLAY`**: For sessions of this type, the MPEG-DASH manifest is updated similarly to how it is updated for `LIVE` mode except that it starts by including fragments from a given start time. Instead of fragments being added as they are ingested, fragments are added as the duration of the next fragment elapses. For example, if the fragments in the session are two seconds long, then a new fragment is added to the manifest every two seconds. This mode is useful to be able to start playback from when an event is detected and continue live streaming media that has not yet been ingested as of the time of the session creation. This mode is also useful to stream previously archived media without being limited by the 1,000 fragment limit in the `ON_DEMAND` mode.
         * + **`ON_DEMAND`**: For sessions of this type, the MPEG-DASH manifest contains all the fragments for the session, up to the number that is specified in `MaxManifestFragmentResults`. The manifest must be retrieved only once for each session. When this type of session is played in a media player, the user interface typically displays a scrubber control for choosing the position in the playback window to display.
         *
         * In all playback modes, if `FragmentSelectorType` is `PRODUCER_TIMESTAMP`, and if there are multiple fragments with the same start timestamp, the fragment that has the larger fragment number (that is, the newer fragment) is included in the MPEG-DASH manifest. The other fragments are not included. Fragments that have different timestamps but have overlapping durations are still included in the MPEG-DASH manifest. This can lead to unexpected behavior in the media player.
         *
         * The default is `LIVE`.
         */
        public var playbackMode: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.DashPlaybackMode? = null
        /**
         * The Amazon Resource Name (ARN) of the stream for which to retrieve the MPEG-DASH manifest URL.
         *
         * You must specify either the `StreamName` or the `StreamARN`.
         */
        public var streamArn: kotlin.String? = null
        /**
         * The name of the stream for which to retrieve the MPEG-DASH manifest URL.
         *
         * You must specify either the `StreamName` or the `StreamARN`.
         */
        public var streamName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest) : this() {
            this.dashFragmentSelector = x.dashFragmentSelector
            this.displayFragmentNumber = x.displayFragmentNumber
            this.displayFragmentTimestamp = x.displayFragmentTimestamp
            this.expires = x.expires
            this.maxManifestFragmentResults = x.maxManifestFragmentResults
            this.playbackMode = x.playbackMode
            this.streamArn = x.streamArn
            this.streamName = x.streamName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest = GetDashStreamingSessionUrlRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.DashFragmentSelector] inside the given [block]
         */
        public fun dashFragmentSelector(block: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.DashFragmentSelector.Builder.() -> kotlin.Unit) {
            this.dashFragmentSelector = aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.DashFragmentSelector.invoke(block)
        }
    }
}
