// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisvideoarchivedmedia.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlResponse
import aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.KinesisVideoArchivedMediaException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetHLSStreamingSessionURLOperationDeserializer: HttpDeserialize<GetHlsStreamingSessionUrlResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetHlsStreamingSessionUrlResponse {
        if (!response.status.isSuccess()) {
            throwGetHlsStreamingSessionUrlError(context, response)
        }
        val builder = GetHlsStreamingSessionUrlResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetHLSStreamingSessionURLOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetHlsStreamingSessionUrlError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KinesisVideoArchivedMediaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ClientLimitExceededException" -> ClientLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidCodecPrivateDataException" -> InvalidCodecPrivateDataExceptionDeserializer().deserialize(context, wrappedResponse)
        "MissingCodecPrivateDataException" -> MissingCodecPrivateDataExceptionDeserializer().deserialize(context, wrappedResponse)
        "NoDataRetentionException" -> NoDataRetentionExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedStreamMediaTypeException" -> UnsupportedStreamMediaTypeExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KinesisVideoArchivedMediaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetHLSStreamingSessionURLOperationBody(builder: GetHlsStreamingSessionUrlResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val HLSSTREAMINGSESSIONURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HLSStreamingSessionURL"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(HLSSTREAMINGSESSIONURL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HLSSTREAMINGSESSIONURL_DESCRIPTOR.index -> builder.hlsStreamingSessionUrl = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
