// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The start and end of the timestamp range for the requested media.
 *
 * This value should not be present if `PlaybackType` is `LIVE`.
 */
public class HlsTimestampRange private constructor(builder: Builder) {
    /**
     * The end of the timestamp range for the requested media. This value must be within 24 hours of the specified `StartTimestamp`, and it must be later than the `StartTimestamp` value.
     *
     * If `FragmentSelectorType` for the request is `SERVER_TIMESTAMP`, this value must be in the past.
     *
     * The `EndTimestamp` value is required for `ON_DEMAND` mode, but optional for `LIVE_REPLAY` mode. If the `EndTimestamp` is not set for `LIVE_REPLAY` mode then the session will continue to include newly ingested fragments until the session expires.
     *
     * This value is inclusive. The `EndTimestamp` is compared to the (starting) timestamp of the fragment. Fragments that start before the `EndTimestamp` value and continue past it are included in the session.
     */
    public val endTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.endTimestamp
    /**
     * The start of the timestamp range for the requested media.
     *
     * If the `HLSTimestampRange` value is specified, the `StartTimestamp` value is required.
     *
     * Only fragments that start exactly at or after `StartTimestamp` are included in the session. Fragments that start before `StartTimestamp` and continue past it aren't included in the session. If `FragmentSelectorType` is `SERVER_TIMESTAMP`, the `StartTimestamp` must be later than the stream head.
     */
    public val startTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.startTimestamp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.HlsTimestampRange = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HlsTimestampRange(")
        append("endTimestamp=$endTimestamp,")
        append("startTimestamp=$startTimestamp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTimestamp?.hashCode() ?: 0
        result = 31 * result + (startTimestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HlsTimestampRange

        if (endTimestamp != other.endTimestamp) return false
        if (startTimestamp != other.startTimestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.HlsTimestampRange = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The end of the timestamp range for the requested media. This value must be within 24 hours of the specified `StartTimestamp`, and it must be later than the `StartTimestamp` value.
         *
         * If `FragmentSelectorType` for the request is `SERVER_TIMESTAMP`, this value must be in the past.
         *
         * The `EndTimestamp` value is required for `ON_DEMAND` mode, but optional for `LIVE_REPLAY` mode. If the `EndTimestamp` is not set for `LIVE_REPLAY` mode then the session will continue to include newly ingested fragments until the session expires.
         *
         * This value is inclusive. The `EndTimestamp` is compared to the (starting) timestamp of the fragment. Fragments that start before the `EndTimestamp` value and continue past it are included in the session.
         */
        public var endTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The start of the timestamp range for the requested media.
         *
         * If the `HLSTimestampRange` value is specified, the `StartTimestamp` value is required.
         *
         * Only fragments that start exactly at or after `StartTimestamp` are included in the session. Fragments that start before `StartTimestamp` and continue past it aren't included in the session. If `FragmentSelectorType` is `SERVER_TIMESTAMP`, the `StartTimestamp` must be later than the stream head.
         */
        public var startTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.HlsTimestampRange) : this() {
            this.endTimestamp = x.endTimestamp
            this.startTimestamp = x.startTimestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.HlsTimestampRange = HlsTimestampRange(this)
    }
}
