// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2.serde

import aws.sdk.kotlin.services.kinesisanalyticsv2.model.DiscoverInputSchemaResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisAnalyticsV2Exception
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.SourceSchema
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DiscoverInputSchemaOperationDeserializer: HttpDeserialize<DiscoverInputSchemaResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DiscoverInputSchemaResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDiscoverInputSchemaError(context, call)
        }
        val builder = DiscoverInputSchemaResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDiscoverInputSchemaOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDiscoverInputSchemaError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KinesisAnalyticsV2Exception("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceProvisionedThroughputExceededException" -> ResourceProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "UnableToDetectSchemaException" -> UnableToDetectSchemaExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        else -> KinesisAnalyticsV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDiscoverInputSchemaOperationBody(builder: DiscoverInputSchemaResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INPUTSCHEMA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("InputSchema"))
    val PARSEDINPUTRECORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ParsedInputRecords"))
    val PARSEDINPUTRECORDS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val PROCESSEDINPUTRECORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProcessedInputRecords"))
    val RAWINPUTRECORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("RawInputRecords"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INPUTSCHEMA_DESCRIPTOR)
        field(PARSEDINPUTRECORDS_DESCRIPTOR)
        field(PROCESSEDINPUTRECORDS_DESCRIPTOR)
        field(RAWINPUTRECORDS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INPUTSCHEMA_DESCRIPTOR.index -> builder.inputSchema = deserializeSourceSchemaDocument(deserializer)
                PARSEDINPUTRECORDS_DESCRIPTOR.index -> builder.parsedInputRecords =
                    deserializer.deserializeList(PARSEDINPUTRECORDS_DESCRIPTOR) {
                        val col0 = mutableListOf<List<String>>()
                        while (hasNextElement()) {
                            val el0 = deserializer.deserializeList(PARSEDINPUTRECORDS_C0_DESCRIPTOR) {
                                val col1 = mutableListOf<String>()
                                while (hasNextElement()) {
                                    val el1 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                                    col1.add(el1)
                                }
                                col1
                            }
                            col0.add(el0)
                        }
                        col0
                    }
                PROCESSEDINPUTRECORDS_DESCRIPTOR.index -> builder.processedInputRecords =
                    deserializer.deserializeList(PROCESSEDINPUTRECORDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                RAWINPUTRECORDS_DESCRIPTOR.index -> builder.rawInputRecords =
                    deserializer.deserializeList(RAWINPUTRECORDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
