// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2.model



/**
 * Describes the parameters of a VPC used by the application.
 */
public class VpcConfigurationDescription private constructor(builder: Builder) {
    /**
     * The array of [SecurityGroup](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SecurityGroup.html) IDs used by the VPC configuration.
     */
    public val securityGroupIds: List<String> = requireNotNull(builder.securityGroupIds) { "A non-null value must be provided for securityGroupIds" }
    /**
     * The array of [Subnet](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Subnet.html) IDs used by the VPC configuration.
     */
    public val subnetIds: List<String> = requireNotNull(builder.subnetIds) { "A non-null value must be provided for subnetIds" }
    /**
     * The ID of the VPC configuration.
     */
    public val vpcConfigurationId: kotlin.String = requireNotNull(builder.vpcConfigurationId) { "A non-null value must be provided for vpcConfigurationId" }
    /**
     * The ID of the associated VPC.
     */
    public val vpcId: kotlin.String = requireNotNull(builder.vpcId) { "A non-null value must be provided for vpcId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalyticsv2.model.VpcConfigurationDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcConfigurationDescription(")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetIds=$subnetIds,")
        append("vpcConfigurationId=$vpcConfigurationId,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = securityGroupIds.hashCode()
        result = 31 * result + (subnetIds.hashCode())
        result = 31 * result + (vpcConfigurationId.hashCode())
        result = 31 * result + (vpcId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcConfigurationDescription

        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetIds != other.subnetIds) return false
        if (vpcConfigurationId != other.vpcConfigurationId) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalyticsv2.model.VpcConfigurationDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The array of [SecurityGroup](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SecurityGroup.html) IDs used by the VPC configuration.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The array of [Subnet](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Subnet.html) IDs used by the VPC configuration.
         */
        public var subnetIds: List<String>? = null
        /**
         * The ID of the VPC configuration.
         */
        public var vpcConfigurationId: kotlin.String? = null
        /**
         * The ID of the associated VPC.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalyticsv2.model.VpcConfigurationDescription) : this() {
            this.securityGroupIds = x.securityGroupIds
            this.subnetIds = x.subnetIds
            this.vpcConfigurationId = x.vpcConfigurationId
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalyticsv2.model.VpcConfigurationDescription = VpcConfigurationDescription(this)

        internal fun correctErrors(): Builder {
            if (securityGroupIds == null) securityGroupIds = emptyList()
            if (subnetIds == null) subnetIds = emptyList()
            if (vpcConfigurationId == null) vpcConfigurationId = ""
            if (vpcId == null) vpcId = ""
            return this
        }
    }
}
