// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2.model



/**
 * For a SQL-based Kinesis Data Analytics application, identifies the Amazon S3 bucket and object that contains the reference data.
 *
 * A Kinesis Data Analytics application loads reference data only once. If the data changes, you call the UpdateApplication operation to trigger reloading of data into your application.
 */
public class S3ReferenceDataSource private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the S3 bucket.
     */
    public val bucketArn: kotlin.String? = builder.bucketArn
    /**
     * The object key name containing the reference data.
     */
    public val fileKey: kotlin.String? = builder.fileKey

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalyticsv2.model.S3ReferenceDataSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3ReferenceDataSource(")
        append("bucketArn=$bucketArn,")
        append("fileKey=$fileKey")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketArn?.hashCode() ?: 0
        result = 31 * result + (fileKey?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3ReferenceDataSource

        if (bucketArn != other.bucketArn) return false
        if (fileKey != other.fileKey) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalyticsv2.model.S3ReferenceDataSource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the S3 bucket.
         */
        public var bucketArn: kotlin.String? = null
        /**
         * The object key name containing the reference data.
         */
        public var fileKey: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalyticsv2.model.S3ReferenceDataSource) : this() {
            this.bucketArn = x.bucketArn
            this.fileKey = x.fileKey
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalyticsv2.model.S3ReferenceDataSource = S3ReferenceDataSource(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
