// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2.model



/**
 * For a SQL-based Kinesis Data Analytics application, describes the reference data source by providing the source information (Amazon S3 bucket name and object key name), the resulting in-application table name that is created, and the necessary schema to map the data elements in the Amazon S3 object to the in-application table.
 */
public class ReferenceDataSource private constructor(builder: Builder) {
    /**
     * Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream.
     */
    public val referenceSchema: aws.sdk.kotlin.services.kinesisanalyticsv2.model.SourceSchema? = builder.referenceSchema
    /**
     * Identifies the S3 bucket and object that contains the reference data. A Kinesis Data Analytics application loads reference data only once. If the data changes, you call the UpdateApplication operation to trigger reloading of data into your application.
     */
    public val s3ReferenceDataSource: aws.sdk.kotlin.services.kinesisanalyticsv2.model.S3ReferenceDataSource? = builder.s3ReferenceDataSource
    /**
     * The name of the in-application table to create.
     */
    public val tableName: kotlin.String = requireNotNull(builder.tableName) { "A non-null value must be provided for tableName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalyticsv2.model.ReferenceDataSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReferenceDataSource(")
        append("referenceSchema=$referenceSchema,")
        append("s3ReferenceDataSource=$s3ReferenceDataSource,")
        append("tableName=$tableName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = referenceSchema?.hashCode() ?: 0
        result = 31 * result + (s3ReferenceDataSource?.hashCode() ?: 0)
        result = 31 * result + (tableName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReferenceDataSource

        if (referenceSchema != other.referenceSchema) return false
        if (s3ReferenceDataSource != other.s3ReferenceDataSource) return false
        if (tableName != other.tableName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalyticsv2.model.ReferenceDataSource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream.
         */
        public var referenceSchema: aws.sdk.kotlin.services.kinesisanalyticsv2.model.SourceSchema? = null
        /**
         * Identifies the S3 bucket and object that contains the reference data. A Kinesis Data Analytics application loads reference data only once. If the data changes, you call the UpdateApplication operation to trigger reloading of data into your application.
         */
        public var s3ReferenceDataSource: aws.sdk.kotlin.services.kinesisanalyticsv2.model.S3ReferenceDataSource? = null
        /**
         * The name of the in-application table to create.
         */
        public var tableName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ReferenceDataSource) : this() {
            this.referenceSchema = x.referenceSchema
            this.s3ReferenceDataSource = x.s3ReferenceDataSource
            this.tableName = x.tableName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalyticsv2.model.ReferenceDataSource = ReferenceDataSource(this)

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.SourceSchema] inside the given [block]
         */
        public fun referenceSchema(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.SourceSchema.Builder.() -> kotlin.Unit) {
            this.referenceSchema = aws.sdk.kotlin.services.kinesisanalyticsv2.model.SourceSchema.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.S3ReferenceDataSource] inside the given [block]
         */
        public fun s3ReferenceDataSource(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.S3ReferenceDataSource.Builder.() -> kotlin.Unit) {
            this.s3ReferenceDataSource = aws.sdk.kotlin.services.kinesisanalyticsv2.model.S3ReferenceDataSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (tableName == null) tableName = ""
            return this
        }
    }
}
