// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2.model



/**
 * Describes a SQL-based Kinesis Data Analytics application's output configuration, in which you identify an in-application stream and a destination where you want the in-application stream data to be written. The destination can be a Kinesis data stream or a Kinesis Data Firehose delivery stream.
 */
public class Output private constructor(builder: Builder) {
    /**
     * Describes the data format when records are written to the destination.
     */
    public val destinationSchema: aws.sdk.kotlin.services.kinesisanalyticsv2.model.DestinationSchema? = builder.destinationSchema
    /**
     * Identifies a Kinesis Data Firehose delivery stream as the destination.
     */
    public val kinesisFirehoseOutput: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisFirehoseOutput? = builder.kinesisFirehoseOutput
    /**
     * Identifies a Kinesis data stream as the destination.
     */
    public val kinesisStreamsOutput: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisStreamsOutput? = builder.kinesisStreamsOutput
    /**
     * Identifies an Amazon Lambda function as the destination.
     */
    public val lambdaOutput: aws.sdk.kotlin.services.kinesisanalyticsv2.model.LambdaOutput? = builder.lambdaOutput
    /**
     * The name of the in-application stream.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalyticsv2.model.Output = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Output(")
        append("destinationSchema=$destinationSchema,")
        append("kinesisFirehoseOutput=$kinesisFirehoseOutput,")
        append("kinesisStreamsOutput=$kinesisStreamsOutput,")
        append("lambdaOutput=$lambdaOutput,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationSchema?.hashCode() ?: 0
        result = 31 * result + (kinesisFirehoseOutput?.hashCode() ?: 0)
        result = 31 * result + (kinesisStreamsOutput?.hashCode() ?: 0)
        result = 31 * result + (lambdaOutput?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Output

        if (destinationSchema != other.destinationSchema) return false
        if (kinesisFirehoseOutput != other.kinesisFirehoseOutput) return false
        if (kinesisStreamsOutput != other.kinesisStreamsOutput) return false
        if (lambdaOutput != other.lambdaOutput) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalyticsv2.model.Output = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Describes the data format when records are written to the destination.
         */
        public var destinationSchema: aws.sdk.kotlin.services.kinesisanalyticsv2.model.DestinationSchema? = null
        /**
         * Identifies a Kinesis Data Firehose delivery stream as the destination.
         */
        public var kinesisFirehoseOutput: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisFirehoseOutput? = null
        /**
         * Identifies a Kinesis data stream as the destination.
         */
        public var kinesisStreamsOutput: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisStreamsOutput? = null
        /**
         * Identifies an Amazon Lambda function as the destination.
         */
        public var lambdaOutput: aws.sdk.kotlin.services.kinesisanalyticsv2.model.LambdaOutput? = null
        /**
         * The name of the in-application stream.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalyticsv2.model.Output) : this() {
            this.destinationSchema = x.destinationSchema
            this.kinesisFirehoseOutput = x.kinesisFirehoseOutput
            this.kinesisStreamsOutput = x.kinesisStreamsOutput
            this.lambdaOutput = x.lambdaOutput
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalyticsv2.model.Output = Output(this)

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.DestinationSchema] inside the given [block]
         */
        public fun destinationSchema(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.DestinationSchema.Builder.() -> kotlin.Unit) {
            this.destinationSchema = aws.sdk.kotlin.services.kinesisanalyticsv2.model.DestinationSchema.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisFirehoseOutput] inside the given [block]
         */
        public fun kinesisFirehoseOutput(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisFirehoseOutput.Builder.() -> kotlin.Unit) {
            this.kinesisFirehoseOutput = aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisFirehoseOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisStreamsOutput] inside the given [block]
         */
        public fun kinesisStreamsOutput(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisStreamsOutput.Builder.() -> kotlin.Unit) {
            this.kinesisStreamsOutput = aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisStreamsOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.LambdaOutput] inside the given [block]
         */
        public fun lambdaOutput(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.LambdaOutput.Builder.() -> kotlin.Unit) {
            this.lambdaOutput = aws.sdk.kotlin.services.kinesisanalyticsv2.model.LambdaOutput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            return this
        }
    }
}
