// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2.model



/**
 * For a SQL-based Kinesis Data Analytics application, describes updates to a specific input configuration (identified by the `InputId` of an application).
 */
public class InputUpdate private constructor(builder: Builder) {
    /**
     * The input ID of the application input to be updated.
     */
    public val inputId: kotlin.String = requireNotNull(builder.inputId) { "A non-null value must be provided for inputId" }
    /**
     * Describes the parallelism updates (the number of in-application streams Kinesis Data Analytics creates for the specific streaming source).
     */
    public val inputParallelismUpdate: aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputParallelismUpdate? = builder.inputParallelismUpdate
    /**
     * Describes updates to an InputProcessingConfiguration.
     */
    public val inputProcessingConfigurationUpdate: aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputProcessingConfigurationUpdate? = builder.inputProcessingConfigurationUpdate
    /**
     * Describes the data format on the streaming source, and how record elements on the streaming source map to columns of the in-application stream that is created.
     */
    public val inputSchemaUpdate: aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputSchemaUpdate? = builder.inputSchemaUpdate
    /**
     * If a Kinesis Data Firehose delivery stream is the streaming source to be updated, provides an updated stream ARN.
     */
    public val kinesisFirehoseInputUpdate: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisFirehoseInputUpdate? = builder.kinesisFirehoseInputUpdate
    /**
     * If a Kinesis data stream is the streaming source to be updated, provides an updated stream Amazon Resource Name (ARN).
     */
    public val kinesisStreamsInputUpdate: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisStreamsInputUpdate? = builder.kinesisStreamsInputUpdate
    /**
     * The name prefix for in-application streams that Kinesis Data Analytics creates for the specific streaming source.
     */
    public val namePrefixUpdate: kotlin.String? = builder.namePrefixUpdate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InputUpdate(")
        append("inputId=$inputId,")
        append("inputParallelismUpdate=$inputParallelismUpdate,")
        append("inputProcessingConfigurationUpdate=$inputProcessingConfigurationUpdate,")
        append("inputSchemaUpdate=$inputSchemaUpdate,")
        append("kinesisFirehoseInputUpdate=$kinesisFirehoseInputUpdate,")
        append("kinesisStreamsInputUpdate=$kinesisStreamsInputUpdate,")
        append("namePrefixUpdate=$namePrefixUpdate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = inputId.hashCode()
        result = 31 * result + (inputParallelismUpdate?.hashCode() ?: 0)
        result = 31 * result + (inputProcessingConfigurationUpdate?.hashCode() ?: 0)
        result = 31 * result + (inputSchemaUpdate?.hashCode() ?: 0)
        result = 31 * result + (kinesisFirehoseInputUpdate?.hashCode() ?: 0)
        result = 31 * result + (kinesisStreamsInputUpdate?.hashCode() ?: 0)
        result = 31 * result + (namePrefixUpdate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InputUpdate

        if (inputId != other.inputId) return false
        if (inputParallelismUpdate != other.inputParallelismUpdate) return false
        if (inputProcessingConfigurationUpdate != other.inputProcessingConfigurationUpdate) return false
        if (inputSchemaUpdate != other.inputSchemaUpdate) return false
        if (kinesisFirehoseInputUpdate != other.kinesisFirehoseInputUpdate) return false
        if (kinesisStreamsInputUpdate != other.kinesisStreamsInputUpdate) return false
        if (namePrefixUpdate != other.namePrefixUpdate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputUpdate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The input ID of the application input to be updated.
         */
        public var inputId: kotlin.String? = null
        /**
         * Describes the parallelism updates (the number of in-application streams Kinesis Data Analytics creates for the specific streaming source).
         */
        public var inputParallelismUpdate: aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputParallelismUpdate? = null
        /**
         * Describes updates to an InputProcessingConfiguration.
         */
        public var inputProcessingConfigurationUpdate: aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputProcessingConfigurationUpdate? = null
        /**
         * Describes the data format on the streaming source, and how record elements on the streaming source map to columns of the in-application stream that is created.
         */
        public var inputSchemaUpdate: aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputSchemaUpdate? = null
        /**
         * If a Kinesis Data Firehose delivery stream is the streaming source to be updated, provides an updated stream ARN.
         */
        public var kinesisFirehoseInputUpdate: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisFirehoseInputUpdate? = null
        /**
         * If a Kinesis data stream is the streaming source to be updated, provides an updated stream Amazon Resource Name (ARN).
         */
        public var kinesisStreamsInputUpdate: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisStreamsInputUpdate? = null
        /**
         * The name prefix for in-application streams that Kinesis Data Analytics creates for the specific streaming source.
         */
        public var namePrefixUpdate: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputUpdate) : this() {
            this.inputId = x.inputId
            this.inputParallelismUpdate = x.inputParallelismUpdate
            this.inputProcessingConfigurationUpdate = x.inputProcessingConfigurationUpdate
            this.inputSchemaUpdate = x.inputSchemaUpdate
            this.kinesisFirehoseInputUpdate = x.kinesisFirehoseInputUpdate
            this.kinesisStreamsInputUpdate = x.kinesisStreamsInputUpdate
            this.namePrefixUpdate = x.namePrefixUpdate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputUpdate = InputUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputParallelismUpdate] inside the given [block]
         */
        public fun inputParallelismUpdate(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputParallelismUpdate.Builder.() -> kotlin.Unit) {
            this.inputParallelismUpdate = aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputParallelismUpdate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputProcessingConfigurationUpdate] inside the given [block]
         */
        public fun inputProcessingConfigurationUpdate(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputProcessingConfigurationUpdate.Builder.() -> kotlin.Unit) {
            this.inputProcessingConfigurationUpdate = aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputProcessingConfigurationUpdate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputSchemaUpdate] inside the given [block]
         */
        public fun inputSchemaUpdate(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputSchemaUpdate.Builder.() -> kotlin.Unit) {
            this.inputSchemaUpdate = aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputSchemaUpdate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisFirehoseInputUpdate] inside the given [block]
         */
        public fun kinesisFirehoseInputUpdate(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisFirehoseInputUpdate.Builder.() -> kotlin.Unit) {
            this.kinesisFirehoseInputUpdate = aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisFirehoseInputUpdate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisStreamsInputUpdate] inside the given [block]
         */
        public fun kinesisStreamsInputUpdate(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisStreamsInputUpdate.Builder.() -> kotlin.Unit) {
            this.kinesisStreamsInputUpdate = aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisStreamsInputUpdate.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (inputId == null) inputId = ""
            return this
        }
    }
}
