// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2.model



/**
 * Specifies either the application code, or the location of the application code, for a Flink-based Kinesis Data Analytics application.
 */
public class CodeContent private constructor(builder: Builder) {
    /**
     * Information about the Amazon S3 bucket that contains the application code.
     */
    public val s3ContentLocation: aws.sdk.kotlin.services.kinesisanalyticsv2.model.S3ContentLocation? = builder.s3ContentLocation
    /**
     * The text-format code for a Flink-based Kinesis Data Analytics application.
     */
    public val textContent: kotlin.String? = builder.textContent
    /**
     * The zip-format code for a Flink-based Kinesis Data Analytics application.
     */
    public val zipFileContent: kotlin.ByteArray? = builder.zipFileContent

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalyticsv2.model.CodeContent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CodeContent(")
        append("s3ContentLocation=$s3ContentLocation,")
        append("textContent=$textContent,")
        append("zipFileContent=$zipFileContent")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = s3ContentLocation?.hashCode() ?: 0
        result = 31 * result + (textContent?.hashCode() ?: 0)
        result = 31 * result + (zipFileContent?.contentHashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CodeContent

        if (s3ContentLocation != other.s3ContentLocation) return false
        if (textContent != other.textContent) return false
        if (zipFileContent != null) {
            if (other.zipFileContent == null) return false
            if (!zipFileContent.contentEquals(other.zipFileContent)) return false
        } else if (other.zipFileContent != null) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalyticsv2.model.CodeContent = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Information about the Amazon S3 bucket that contains the application code.
         */
        public var s3ContentLocation: aws.sdk.kotlin.services.kinesisanalyticsv2.model.S3ContentLocation? = null
        /**
         * The text-format code for a Flink-based Kinesis Data Analytics application.
         */
        public var textContent: kotlin.String? = null
        /**
         * The zip-format code for a Flink-based Kinesis Data Analytics application.
         */
        public var zipFileContent: kotlin.ByteArray? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalyticsv2.model.CodeContent) : this() {
            this.s3ContentLocation = x.s3ContentLocation
            this.textContent = x.textContent
            this.zipFileContent = x.zipFileContent
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalyticsv2.model.CodeContent = CodeContent(this)

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.S3ContentLocation] inside the given [block]
         */
        public fun s3ContentLocation(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.S3ContentLocation.Builder.() -> kotlin.Unit) {
            this.s3ContentLocation = aws.sdk.kotlin.services.kinesisanalyticsv2.model.S3ContentLocation.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
