// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2.model



/**
 * Provides application summary information, including the application Amazon Resource Name (ARN), name, and status.
 */
public class ApplicationSummary private constructor(builder: Builder) {
    /**
     * The ARN of the application.
     */
    public val applicationArn: kotlin.String = requireNotNull(builder.applicationArn) { "A non-null value must be provided for applicationArn" }
    /**
     * For a Kinesis Data Analytics for Apache Flink application, the mode is `STREAMING`. For a Kinesis Data Analytics Studio notebook, it is `INTERACTIVE`.
     */
    public val applicationMode: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ApplicationMode? = builder.applicationMode
    /**
     * The name of the application.
     */
    public val applicationName: kotlin.String = requireNotNull(builder.applicationName) { "A non-null value must be provided for applicationName" }
    /**
     * The status of the application.
     */
    public val applicationStatus: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ApplicationStatus = requireNotNull(builder.applicationStatus) { "A non-null value must be provided for applicationStatus" }
    /**
     * Provides the current application version.
     */
    public val applicationVersionId: kotlin.Long = requireNotNull(builder.applicationVersionId) { "A non-null value must be provided for applicationVersionId" }
    /**
     * The runtime environment for the application.
     */
    public val runtimeEnvironment: aws.sdk.kotlin.services.kinesisanalyticsv2.model.RuntimeEnvironment = requireNotNull(builder.runtimeEnvironment) { "A non-null value must be provided for runtimeEnvironment" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalyticsv2.model.ApplicationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationSummary(")
        append("applicationArn=$applicationArn,")
        append("applicationMode=$applicationMode,")
        append("applicationName=$applicationName,")
        append("applicationStatus=$applicationStatus,")
        append("applicationVersionId=$applicationVersionId,")
        append("runtimeEnvironment=$runtimeEnvironment")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationArn.hashCode()
        result = 31 * result + (applicationMode?.hashCode() ?: 0)
        result = 31 * result + (applicationName.hashCode())
        result = 31 * result + (applicationStatus.hashCode())
        result = 31 * result + (applicationVersionId.hashCode())
        result = 31 * result + (runtimeEnvironment.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApplicationSummary

        if (applicationArn != other.applicationArn) return false
        if (applicationMode != other.applicationMode) return false
        if (applicationName != other.applicationName) return false
        if (applicationStatus != other.applicationStatus) return false
        if (applicationVersionId != other.applicationVersionId) return false
        if (runtimeEnvironment != other.runtimeEnvironment) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalyticsv2.model.ApplicationSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the application.
         */
        public var applicationArn: kotlin.String? = null
        /**
         * For a Kinesis Data Analytics for Apache Flink application, the mode is `STREAMING`. For a Kinesis Data Analytics Studio notebook, it is `INTERACTIVE`.
         */
        public var applicationMode: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ApplicationMode? = null
        /**
         * The name of the application.
         */
        public var applicationName: kotlin.String? = null
        /**
         * The status of the application.
         */
        public var applicationStatus: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ApplicationStatus? = null
        /**
         * Provides the current application version.
         */
        public var applicationVersionId: kotlin.Long? = null
        /**
         * The runtime environment for the application.
         */
        public var runtimeEnvironment: aws.sdk.kotlin.services.kinesisanalyticsv2.model.RuntimeEnvironment? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ApplicationSummary) : this() {
            this.applicationArn = x.applicationArn
            this.applicationMode = x.applicationMode
            this.applicationName = x.applicationName
            this.applicationStatus = x.applicationStatus
            this.applicationVersionId = x.applicationVersionId
            this.runtimeEnvironment = x.runtimeEnvironment
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalyticsv2.model.ApplicationSummary = ApplicationSummary(this)

        internal fun correctErrors(): Builder {
            if (applicationArn == null) applicationArn = ""
            if (applicationName == null) applicationName = ""
            if (applicationStatus == null) applicationStatus = ApplicationStatus.SdkUnknown("no value provided")
            if (applicationVersionId == null) applicationVersionId = 0L
            if (runtimeEnvironment == null) runtimeEnvironment = RuntimeEnvironment.SdkUnknown("no value provided")
            return this
        }
    }
}
