// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2.serde

import aws.sdk.kotlin.services.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisAnalyticsV2Exception
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateApplicationMaintenanceConfigurationOperationDeserializer: HttpDeserialize<UpdateApplicationMaintenanceConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateApplicationMaintenanceConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateApplicationMaintenanceConfigurationError(context, call)
        }
        val builder = UpdateApplicationMaintenanceConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateApplicationMaintenanceConfigurationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateApplicationMaintenanceConfigurationError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KinesisAnalyticsV2Exception("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall)
        "ConcurrentModificationException" -> ConcurrentModificationExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceInUseException" -> ResourceInUseExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> KinesisAnalyticsV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateApplicationMaintenanceConfigurationOperationBody(builder: UpdateApplicationMaintenanceConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPLICATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ApplicationARN"))
    val APPLICATIONMAINTENANCECONFIGURATIONDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ApplicationMaintenanceConfigurationDescription"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLICATIONARN_DESCRIPTOR)
        field(APPLICATIONMAINTENANCECONFIGURATIONDESCRIPTION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLICATIONARN_DESCRIPTOR.index -> builder.applicationArn = deserializeString()
                APPLICATIONMAINTENANCECONFIGURATIONDESCRIPTION_DESCRIPTOR.index -> builder.applicationMaintenanceConfigurationDescription = deserializeApplicationMaintenanceConfigurationDescriptionDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
