// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2.model



/**
 * Describes updates to parameters for how an application executes multiple tasks simultaneously.
 */
public class ParallelismConfigurationUpdate private constructor(builder: Builder) {
    /**
     * Describes updates to whether the Kinesis Data Analytics service can increase the parallelism of a Flink-based Kinesis Data Analytics application in response to increased throughput.
     */
    public val autoScalingEnabledUpdate: kotlin.Boolean? = builder.autoScalingEnabledUpdate
    /**
     * Describes updates to whether the application uses the default parallelism for the Kinesis Data Analytics service, or if a custom parallelism is used. You must set this property to `CUSTOM` in order to change your application's `AutoScalingEnabled`, `Parallelism`, or `ParallelismPerKPU` properties.
     */
    public val configurationTypeUpdate: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ConfigurationType? = builder.configurationTypeUpdate
    /**
     * Describes updates to the number of parallel tasks an application can perform per Kinesis Processing Unit (KPU) used by the application.
     */
    public val parallelismPerKpuUpdate: kotlin.Int? = builder.parallelismPerKpuUpdate
    /**
     * Describes updates to the initial number of parallel tasks an application can perform. If `AutoScalingEnabled` is set to True, then Kinesis Data Analytics can increase the `CurrentParallelism` value in response to application load. The service can increase `CurrentParallelism` up to the maximum parallelism, which is `ParalellismPerKPU` times the maximum KPUs for the application. The maximum KPUs for an application is 32 by default, and can be increased by requesting a limit increase. If application load is reduced, the service will reduce `CurrentParallelism` down to the `Parallelism` setting.
     */
    public val parallelismUpdate: kotlin.Int? = builder.parallelismUpdate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalyticsv2.model.ParallelismConfigurationUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ParallelismConfigurationUpdate(")
        append("autoScalingEnabledUpdate=$autoScalingEnabledUpdate,")
        append("configurationTypeUpdate=$configurationTypeUpdate,")
        append("parallelismPerKpuUpdate=$parallelismPerKpuUpdate,")
        append("parallelismUpdate=$parallelismUpdate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingEnabledUpdate?.hashCode() ?: 0
        result = 31 * result + (configurationTypeUpdate?.hashCode() ?: 0)
        result = 31 * result + (parallelismPerKpuUpdate ?: 0)
        result = 31 * result + (parallelismUpdate ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ParallelismConfigurationUpdate

        if (autoScalingEnabledUpdate != other.autoScalingEnabledUpdate) return false
        if (configurationTypeUpdate != other.configurationTypeUpdate) return false
        if (parallelismPerKpuUpdate != other.parallelismPerKpuUpdate) return false
        if (parallelismUpdate != other.parallelismUpdate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalyticsv2.model.ParallelismConfigurationUpdate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Describes updates to whether the Kinesis Data Analytics service can increase the parallelism of a Flink-based Kinesis Data Analytics application in response to increased throughput.
         */
        public var autoScalingEnabledUpdate: kotlin.Boolean? = null
        /**
         * Describes updates to whether the application uses the default parallelism for the Kinesis Data Analytics service, or if a custom parallelism is used. You must set this property to `CUSTOM` in order to change your application's `AutoScalingEnabled`, `Parallelism`, or `ParallelismPerKPU` properties.
         */
        public var configurationTypeUpdate: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ConfigurationType? = null
        /**
         * Describes updates to the number of parallel tasks an application can perform per Kinesis Processing Unit (KPU) used by the application.
         */
        public var parallelismPerKpuUpdate: kotlin.Int? = null
        /**
         * Describes updates to the initial number of parallel tasks an application can perform. If `AutoScalingEnabled` is set to True, then Kinesis Data Analytics can increase the `CurrentParallelism` value in response to application load. The service can increase `CurrentParallelism` up to the maximum parallelism, which is `ParalellismPerKPU` times the maximum KPUs for the application. The maximum KPUs for an application is 32 by default, and can be increased by requesting a limit increase. If application load is reduced, the service will reduce `CurrentParallelism` down to the `Parallelism` setting.
         */
        public var parallelismUpdate: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ParallelismConfigurationUpdate) : this() {
            this.autoScalingEnabledUpdate = x.autoScalingEnabledUpdate
            this.configurationTypeUpdate = x.configurationTypeUpdate
            this.parallelismPerKpuUpdate = x.parallelismPerKpuUpdate
            this.parallelismUpdate = x.parallelismUpdate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalyticsv2.model.ParallelismConfigurationUpdate = ParallelismConfigurationUpdate(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
