// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2.model



/**
 * For a SQL-based Kinesis Data Analytics application, describes the application output configuration, which includes the in-application stream name and the destination where the stream data is written. The destination can be a Kinesis data stream or a Kinesis Data Firehose delivery stream.
 */
public class OutputDescription private constructor(builder: Builder) {
    /**
     * The data format used for writing data to the destination.
     */
    public val destinationSchema: aws.sdk.kotlin.services.kinesisanalyticsv2.model.DestinationSchema? = builder.destinationSchema
    /**
     * Describes the Kinesis Data Firehose delivery stream that is configured as the destination where output is written.
     */
    public val kinesisFirehoseOutputDescription: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisFirehoseOutputDescription? = builder.kinesisFirehoseOutputDescription
    /**
     * Describes the Kinesis data stream that is configured as the destination where output is written.
     */
    public val kinesisStreamsOutputDescription: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisStreamsOutputDescription? = builder.kinesisStreamsOutputDescription
    /**
     * Describes the Lambda function that is configured as the destination where output is written.
     */
    public val lambdaOutputDescription: aws.sdk.kotlin.services.kinesisanalyticsv2.model.LambdaOutputDescription? = builder.lambdaOutputDescription
    /**
     * The name of the in-application stream that is configured as output.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A unique identifier for the output configuration.
     */
    public val outputId: kotlin.String? = builder.outputId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalyticsv2.model.OutputDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OutputDescription(")
        append("destinationSchema=$destinationSchema,")
        append("kinesisFirehoseOutputDescription=$kinesisFirehoseOutputDescription,")
        append("kinesisStreamsOutputDescription=$kinesisStreamsOutputDescription,")
        append("lambdaOutputDescription=$lambdaOutputDescription,")
        append("name=$name,")
        append("outputId=$outputId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationSchema?.hashCode() ?: 0
        result = 31 * result + (kinesisFirehoseOutputDescription?.hashCode() ?: 0)
        result = 31 * result + (kinesisStreamsOutputDescription?.hashCode() ?: 0)
        result = 31 * result + (lambdaOutputDescription?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outputId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OutputDescription

        if (destinationSchema != other.destinationSchema) return false
        if (kinesisFirehoseOutputDescription != other.kinesisFirehoseOutputDescription) return false
        if (kinesisStreamsOutputDescription != other.kinesisStreamsOutputDescription) return false
        if (lambdaOutputDescription != other.lambdaOutputDescription) return false
        if (name != other.name) return false
        if (outputId != other.outputId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalyticsv2.model.OutputDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The data format used for writing data to the destination.
         */
        public var destinationSchema: aws.sdk.kotlin.services.kinesisanalyticsv2.model.DestinationSchema? = null
        /**
         * Describes the Kinesis Data Firehose delivery stream that is configured as the destination where output is written.
         */
        public var kinesisFirehoseOutputDescription: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisFirehoseOutputDescription? = null
        /**
         * Describes the Kinesis data stream that is configured as the destination where output is written.
         */
        public var kinesisStreamsOutputDescription: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisStreamsOutputDescription? = null
        /**
         * Describes the Lambda function that is configured as the destination where output is written.
         */
        public var lambdaOutputDescription: aws.sdk.kotlin.services.kinesisanalyticsv2.model.LambdaOutputDescription? = null
        /**
         * The name of the in-application stream that is configured as output.
         */
        public var name: kotlin.String? = null
        /**
         * A unique identifier for the output configuration.
         */
        public var outputId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalyticsv2.model.OutputDescription) : this() {
            this.destinationSchema = x.destinationSchema
            this.kinesisFirehoseOutputDescription = x.kinesisFirehoseOutputDescription
            this.kinesisStreamsOutputDescription = x.kinesisStreamsOutputDescription
            this.lambdaOutputDescription = x.lambdaOutputDescription
            this.name = x.name
            this.outputId = x.outputId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalyticsv2.model.OutputDescription = OutputDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.DestinationSchema] inside the given [block]
         */
        public fun destinationSchema(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.DestinationSchema.Builder.() -> kotlin.Unit) {
            this.destinationSchema = aws.sdk.kotlin.services.kinesisanalyticsv2.model.DestinationSchema.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisFirehoseOutputDescription] inside the given [block]
         */
        public fun kinesisFirehoseOutputDescription(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisFirehoseOutputDescription.Builder.() -> kotlin.Unit) {
            this.kinesisFirehoseOutputDescription = aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisFirehoseOutputDescription.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisStreamsOutputDescription] inside the given [block]
         */
        public fun kinesisStreamsOutputDescription(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisStreamsOutputDescription.Builder.() -> kotlin.Unit) {
            this.kinesisStreamsOutputDescription = aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisStreamsOutputDescription.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.LambdaOutputDescription] inside the given [block]
         */
        public fun lambdaOutputDescription(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.LambdaOutputDescription.Builder.() -> kotlin.Unit) {
            this.lambdaOutputDescription = aws.sdk.kotlin.services.kinesisanalyticsv2.model.LambdaOutputDescription.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
