// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2.model



/**
 * Describes configuration parameters for Amazon CloudWatch logging for an application. For more information about CloudWatch logging, see [Monitoring](https://docs.aws.amazon.com/kinesisanalytics/latest/java/monitoring-overview.html).
 */
public class MonitoringConfiguration private constructor(builder: Builder) {
    /**
     * Describes whether to use the default CloudWatch logging configuration for an application. You must set this property to `CUSTOM` in order to set the `LogLevel` or `MetricsLevel` parameters.
     */
    public val configurationType: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ConfigurationType = requireNotNull(builder.configurationType) { "A non-null value must be provided for configurationType" }
    /**
     * Describes the verbosity of the CloudWatch Logs for an application.
     */
    public val logLevel: aws.sdk.kotlin.services.kinesisanalyticsv2.model.LogLevel? = builder.logLevel
    /**
     * Describes the granularity of the CloudWatch Logs for an application. The `Parallelism` level is not recommended for applications with a Parallelism over 64 due to excessive costs.
     */
    public val metricsLevel: aws.sdk.kotlin.services.kinesisanalyticsv2.model.MetricsLevel? = builder.metricsLevel

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalyticsv2.model.MonitoringConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MonitoringConfiguration(")
        append("configurationType=$configurationType,")
        append("logLevel=$logLevel,")
        append("metricsLevel=$metricsLevel")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationType.hashCode()
        result = 31 * result + (logLevel?.hashCode() ?: 0)
        result = 31 * result + (metricsLevel?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MonitoringConfiguration

        if (configurationType != other.configurationType) return false
        if (logLevel != other.logLevel) return false
        if (metricsLevel != other.metricsLevel) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalyticsv2.model.MonitoringConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Describes whether to use the default CloudWatch logging configuration for an application. You must set this property to `CUSTOM` in order to set the `LogLevel` or `MetricsLevel` parameters.
         */
        public var configurationType: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ConfigurationType? = null
        /**
         * Describes the verbosity of the CloudWatch Logs for an application.
         */
        public var logLevel: aws.sdk.kotlin.services.kinesisanalyticsv2.model.LogLevel? = null
        /**
         * Describes the granularity of the CloudWatch Logs for an application. The `Parallelism` level is not recommended for applications with a Parallelism over 64 due to excessive costs.
         */
        public var metricsLevel: aws.sdk.kotlin.services.kinesisanalyticsv2.model.MetricsLevel? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalyticsv2.model.MonitoringConfiguration) : this() {
            this.configurationType = x.configurationType
            this.logLevel = x.logLevel
            this.metricsLevel = x.metricsLevel
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalyticsv2.model.MonitoringConfiguration = MonitoringConfiguration(this)

        internal fun correctErrors(): Builder {
            if (configurationType == null) configurationType = ConfigurationType.SdkUnknown("no value provided")
            return this
        }
    }
}
