// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2.model



/**
 * For a SQL-based Kinesis Data Analytics application's output, describes the Amazon Lambda function that is configured as its destination.
 */
public class LambdaOutputDescription private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the destination Lambda function.
     */
    public val resourceArn: kotlin.String = requireNotNull(builder.resourceArn) { "A non-null value must be provided for resourceArn" }
    /**
     * The ARN of the IAM role that Kinesis Data Analytics can assume to write to the destination function.
     *
     * Provided for backward compatibility. Applications that are created with the current API version have an application-level service execution role rather than a resource-level role.
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalyticsv2.model.LambdaOutputDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaOutputDescription(")
        append("resourceArn=$resourceArn,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceArn.hashCode()
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LambdaOutputDescription

        if (resourceArn != other.resourceArn) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalyticsv2.model.LambdaOutputDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the destination Lambda function.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The ARN of the IAM role that Kinesis Data Analytics can assume to write to the destination function.
         *
         * Provided for backward compatibility. Applications that are created with the current API version have an application-level service execution role rather than a resource-level role.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalyticsv2.model.LambdaOutputDescription) : this() {
            this.resourceArn = x.resourceArn
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalyticsv2.model.LambdaOutputDescription = LambdaOutputDescription(this)

        internal fun correctErrors(): Builder {
            if (resourceArn == null) resourceArn = ""
            return this
        }
    }
}
