// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2.model



/**
 * When you configure a SQL-based Kinesis Data Analytics application's output, identifies an Amazon Lambda function as the destination. You provide the function Amazon Resource Name (ARN) of the Lambda function.
 */
public class LambdaOutput private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the destination Lambda function to write to.
     *
     * To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see [Example ARNs: Amazon Lambda](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
     */
    public val resourceArn: kotlin.String = requireNotNull(builder.resourceArn) { "A non-null value must be provided for resourceArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalyticsv2.model.LambdaOutput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaOutput(")
        append("resourceArn=$resourceArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceArn.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LambdaOutput

        if (resourceArn != other.resourceArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalyticsv2.model.LambdaOutput = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the destination Lambda function to write to.
         *
         * To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see [Example ARNs: Amazon Lambda](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
         */
        public var resourceArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalyticsv2.model.LambdaOutput) : this() {
            this.resourceArn = x.resourceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalyticsv2.model.LambdaOutput = LambdaOutput(this)

        internal fun correctErrors(): Builder {
            if (resourceArn == null) resourceArn = ""
            return this
        }
    }
}
