// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2.model



/**
 * Describes the Amazon CloudWatch logging option.
 */
public class CloudWatchLoggingOptionDescription private constructor(builder: Builder) {
    /**
     * The ID of the CloudWatch logging option description.
     */
    public val cloudWatchLoggingOptionId: kotlin.String? = builder.cloudWatchLoggingOptionId
    /**
     * The Amazon Resource Name (ARN) of the CloudWatch log to receive application messages.
     */
    public val logStreamArn: kotlin.String = requireNotNull(builder.logStreamArn) { "A non-null value must be provided for logStreamArn" }
    /**
     * The IAM ARN of the role to use to send application messages.
     *
     * Provided for backward compatibility. Applications created with the current API version have an application-level service execution role rather than a resource-level role.
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CloudWatchLoggingOptionDescription(")
        append("cloudWatchLoggingOptionId=$cloudWatchLoggingOptionId,")
        append("logStreamArn=$logStreamArn,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLoggingOptionId?.hashCode() ?: 0
        result = 31 * result + (logStreamArn.hashCode())
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CloudWatchLoggingOptionDescription

        if (cloudWatchLoggingOptionId != other.cloudWatchLoggingOptionId) return false
        if (logStreamArn != other.logStreamArn) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the CloudWatch logging option description.
         */
        public var cloudWatchLoggingOptionId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the CloudWatch log to receive application messages.
         */
        public var logStreamArn: kotlin.String? = null
        /**
         * The IAM ARN of the role to use to send application messages.
         *
         * Provided for backward compatibility. Applications created with the current API version have an application-level service execution role rather than a resource-level role.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription) : this() {
            this.cloudWatchLoggingOptionId = x.cloudWatchLoggingOptionId
            this.logStreamArn = x.logStreamArn
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription = CloudWatchLoggingOptionDescription(this)

        internal fun correctErrors(): Builder {
            if (logStreamArn == null) logStreamArn = ""
            return this
        }
    }
}
