// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2.model



/**
 * For a SQL-based Kinesis Data Analytics application, describes the reference data source configured for an application.
 */
public class ReferenceDataSourceDescription private constructor(builder: Builder) {
    /**
     * The ID of the reference data source. This is the ID that Kinesis Data Analytics assigns when you add the reference data source to your application using the CreateApplication or UpdateApplication operation.
     */
    public val referenceId: kotlin.String? = builder.referenceId
    /**
     * Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream.
     */
    public val referenceSchema: aws.sdk.kotlin.services.kinesisanalyticsv2.model.SourceSchema? = builder.referenceSchema
    /**
     * Provides the Amazon S3 bucket name, the object key name that contains the reference data.
     */
    public val s3ReferenceDataSourceDescription: aws.sdk.kotlin.services.kinesisanalyticsv2.model.S3ReferenceDataSourceDescription? = builder.s3ReferenceDataSourceDescription
    /**
     * The in-application table name created by the specific reference data source configuration.
     */
    public val tableName: kotlin.String? = builder.tableName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalyticsv2.model.ReferenceDataSourceDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReferenceDataSourceDescription(")
        append("referenceId=$referenceId,")
        append("referenceSchema=$referenceSchema,")
        append("s3ReferenceDataSourceDescription=$s3ReferenceDataSourceDescription,")
        append("tableName=$tableName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = referenceId?.hashCode() ?: 0
        result = 31 * result + (referenceSchema?.hashCode() ?: 0)
        result = 31 * result + (s3ReferenceDataSourceDescription?.hashCode() ?: 0)
        result = 31 * result + (tableName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReferenceDataSourceDescription

        if (referenceId != other.referenceId) return false
        if (referenceSchema != other.referenceSchema) return false
        if (s3ReferenceDataSourceDescription != other.s3ReferenceDataSourceDescription) return false
        if (tableName != other.tableName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalyticsv2.model.ReferenceDataSourceDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the reference data source. This is the ID that Kinesis Data Analytics assigns when you add the reference data source to your application using the CreateApplication or UpdateApplication operation.
         */
        public var referenceId: kotlin.String? = null
        /**
         * Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream.
         */
        public var referenceSchema: aws.sdk.kotlin.services.kinesisanalyticsv2.model.SourceSchema? = null
        /**
         * Provides the Amazon S3 bucket name, the object key name that contains the reference data.
         */
        public var s3ReferenceDataSourceDescription: aws.sdk.kotlin.services.kinesisanalyticsv2.model.S3ReferenceDataSourceDescription? = null
        /**
         * The in-application table name created by the specific reference data source configuration.
         */
        public var tableName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ReferenceDataSourceDescription) : this() {
            this.referenceId = x.referenceId
            this.referenceSchema = x.referenceSchema
            this.s3ReferenceDataSourceDescription = x.s3ReferenceDataSourceDescription
            this.tableName = x.tableName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalyticsv2.model.ReferenceDataSourceDescription = ReferenceDataSourceDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.SourceSchema] inside the given [block]
         */
        public fun referenceSchema(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.SourceSchema.Builder.() -> kotlin.Unit) {
            this.referenceSchema = aws.sdk.kotlin.services.kinesisanalyticsv2.model.SourceSchema.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.S3ReferenceDataSourceDescription] inside the given [block]
         */
        public fun s3ReferenceDataSourceDescription(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.S3ReferenceDataSourceDescription.Builder.() -> kotlin.Unit) {
            this.s3ReferenceDataSourceDescription = aws.sdk.kotlin.services.kinesisanalyticsv2.model.S3ReferenceDataSourceDescription.invoke(block)
        }
    }
}
