// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2.model



/**
 * For a SQL-based Kinesis Data Analytics application, describes the mapping of each data element in the streaming source to the corresponding column in the in-application stream.
 *
 * Also used to describe the format of the reference data source.
 */
public class RecordColumn private constructor(builder: Builder) {
    /**
     * A reference to the data element in the streaming input or the reference data source.
     */
    public val mapping: kotlin.String? = builder.mapping
    /**
     * The name of the column that is created in the in-application input stream or reference table.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The type of column created in the in-application input stream or reference table.
     */
    public val sqlType: kotlin.String? = builder.sqlType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalyticsv2.model.RecordColumn = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecordColumn(")
        append("mapping=$mapping,")
        append("name=$name,")
        append("sqlType=$sqlType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = mapping?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (sqlType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecordColumn

        if (mapping != other.mapping) return false
        if (name != other.name) return false
        if (sqlType != other.sqlType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalyticsv2.model.RecordColumn = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A reference to the data element in the streaming input or the reference data source.
         */
        public var mapping: kotlin.String? = null
        /**
         * The name of the column that is created in the in-application input stream or reference table.
         */
        public var name: kotlin.String? = null
        /**
         * The type of column created in the in-application input stream or reference table.
         */
        public var sqlType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalyticsv2.model.RecordColumn) : this() {
            this.mapping = x.mapping
            this.name = x.name
            this.sqlType = x.sqlType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalyticsv2.model.RecordColumn = RecordColumn(this)
    }
}
