// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2.model



/**
 * Describes parameters for how a Flink-based Kinesis Data Analytics application executes multiple tasks simultaneously.
 */
public class ParallelismConfigurationDescription private constructor(builder: Builder) {
    /**
     * Describes whether the Kinesis Data Analytics service can increase the parallelism of the application in response to increased throughput.
     */
    public val autoScalingEnabled: kotlin.Boolean? = builder.autoScalingEnabled
    /**
     * Describes whether the application uses the default parallelism for the Kinesis Data Analytics service.
     */
    public val configurationType: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ConfigurationType? = builder.configurationType
    /**
     * Describes the current number of parallel tasks that a Flink-based Kinesis Data Analytics application can perform. If `AutoScalingEnabled` is set to True, Kinesis Data Analytics can increase this value in response to application load. The service can increase this value up to the maximum parallelism, which is `ParalellismPerKPU` times the maximum KPUs for the application. The maximum KPUs for an application is 32 by default, and can be increased by requesting a limit increase. If application load is reduced, the service can reduce the `CurrentParallelism` value down to the `Parallelism` setting.
     */
    public val currentParallelism: kotlin.Int? = builder.currentParallelism
    /**
     * Describes the initial number of parallel tasks that a Flink-based Kinesis Data Analytics application can perform. If `AutoScalingEnabled` is set to True, then Kinesis Data Analytics can increase the `CurrentParallelism` value in response to application load. The service can increase `CurrentParallelism` up to the maximum parallelism, which is `ParalellismPerKPU` times the maximum KPUs for the application. The maximum KPUs for an application is 32 by default, and can be increased by requesting a limit increase. If application load is reduced, the service can reduce the `CurrentParallelism` value down to the `Parallelism` setting.
     */
    public val parallelism: kotlin.Int? = builder.parallelism
    /**
     * Describes the number of parallel tasks that a Flink-based Kinesis Data Analytics application can perform per Kinesis Processing Unit (KPU) used by the application.
     */
    public val parallelismPerKpu: kotlin.Int? = builder.parallelismPerKpu

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalyticsv2.model.ParallelismConfigurationDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ParallelismConfigurationDescription(")
        append("autoScalingEnabled=$autoScalingEnabled,")
        append("configurationType=$configurationType,")
        append("currentParallelism=$currentParallelism,")
        append("parallelism=$parallelism,")
        append("parallelismPerKpu=$parallelismPerKpu)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingEnabled?.hashCode() ?: 0
        result = 31 * result + (configurationType?.hashCode() ?: 0)
        result = 31 * result + (currentParallelism ?: 0)
        result = 31 * result + (parallelism ?: 0)
        result = 31 * result + (parallelismPerKpu ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ParallelismConfigurationDescription

        if (autoScalingEnabled != other.autoScalingEnabled) return false
        if (configurationType != other.configurationType) return false
        if (currentParallelism != other.currentParallelism) return false
        if (parallelism != other.parallelism) return false
        if (parallelismPerKpu != other.parallelismPerKpu) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalyticsv2.model.ParallelismConfigurationDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Describes whether the Kinesis Data Analytics service can increase the parallelism of the application in response to increased throughput.
         */
        public var autoScalingEnabled: kotlin.Boolean? = null
        /**
         * Describes whether the application uses the default parallelism for the Kinesis Data Analytics service.
         */
        public var configurationType: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ConfigurationType? = null
        /**
         * Describes the current number of parallel tasks that a Flink-based Kinesis Data Analytics application can perform. If `AutoScalingEnabled` is set to True, Kinesis Data Analytics can increase this value in response to application load. The service can increase this value up to the maximum parallelism, which is `ParalellismPerKPU` times the maximum KPUs for the application. The maximum KPUs for an application is 32 by default, and can be increased by requesting a limit increase. If application load is reduced, the service can reduce the `CurrentParallelism` value down to the `Parallelism` setting.
         */
        public var currentParallelism: kotlin.Int? = null
        /**
         * Describes the initial number of parallel tasks that a Flink-based Kinesis Data Analytics application can perform. If `AutoScalingEnabled` is set to True, then Kinesis Data Analytics can increase the `CurrentParallelism` value in response to application load. The service can increase `CurrentParallelism` up to the maximum parallelism, which is `ParalellismPerKPU` times the maximum KPUs for the application. The maximum KPUs for an application is 32 by default, and can be increased by requesting a limit increase. If application load is reduced, the service can reduce the `CurrentParallelism` value down to the `Parallelism` setting.
         */
        public var parallelism: kotlin.Int? = null
        /**
         * Describes the number of parallel tasks that a Flink-based Kinesis Data Analytics application can perform per Kinesis Processing Unit (KPU) used by the application.
         */
        public var parallelismPerKpu: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ParallelismConfigurationDescription) : this() {
            this.autoScalingEnabled = x.autoScalingEnabled
            this.configurationType = x.configurationType
            this.currentParallelism = x.currentParallelism
            this.parallelism = x.parallelism
            this.parallelismPerKpu = x.parallelismPerKpu
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalyticsv2.model.ParallelismConfigurationDescription = ParallelismConfigurationDescription(this)
    }
}
