// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2.model



/**
 * When you configure the application input for a SQL-based Kinesis Data Analytics application, you specify the streaming source, the in-application stream name that is created, and the mapping between the two.
 */
public class Input private constructor(builder: Builder) {
    /**
     * Describes the number of in-application streams to create.
     */
    public val inputParallelism: aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputParallelism? = builder.inputParallelism
    /**
     * The InputProcessingConfiguration for the input. An input processor transforms records as they are received from the stream, before the application's SQL code executes. Currently, the only input processing configuration available is InputLambdaProcessor.
     */
    public val inputProcessingConfiguration: aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputProcessingConfiguration? = builder.inputProcessingConfiguration
    /**
     * Describes the format of the data in the streaming source, and how each data element maps to corresponding columns in the in-application stream that is being created.
     *
     * Also used to describe the format of the reference data source.
     */
    public val inputSchema: aws.sdk.kotlin.services.kinesisanalyticsv2.model.SourceSchema? = builder.inputSchema
    /**
     * If the streaming source is an Amazon Kinesis Data Firehose delivery stream, identifies the delivery stream's ARN.
     */
    public val kinesisFirehoseInput: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisFirehoseInput? = builder.kinesisFirehoseInput
    /**
     * If the streaming source is an Amazon Kinesis data stream, identifies the stream's Amazon Resource Name (ARN).
     */
    public val kinesisStreamsInput: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisStreamsInput? = builder.kinesisStreamsInput
    /**
     * The name prefix to use when creating an in-application stream. Suppose that you specify a prefix "`MyInApplicationStream`." Kinesis Data Analytics then creates one or more (as per the `InputParallelism` count you specified) in-application streams with the names "`MyInApplicationStream_001`," "`MyInApplicationStream_002`," and so on.
     */
    public val namePrefix: kotlin.String? = builder.namePrefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalyticsv2.model.Input = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Input(")
        append("inputParallelism=$inputParallelism,")
        append("inputProcessingConfiguration=$inputProcessingConfiguration,")
        append("inputSchema=$inputSchema,")
        append("kinesisFirehoseInput=$kinesisFirehoseInput,")
        append("kinesisStreamsInput=$kinesisStreamsInput,")
        append("namePrefix=$namePrefix)")
    }

    override fun hashCode(): kotlin.Int {
        var result = inputParallelism?.hashCode() ?: 0
        result = 31 * result + (inputProcessingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (inputSchema?.hashCode() ?: 0)
        result = 31 * result + (kinesisFirehoseInput?.hashCode() ?: 0)
        result = 31 * result + (kinesisStreamsInput?.hashCode() ?: 0)
        result = 31 * result + (namePrefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Input

        if (inputParallelism != other.inputParallelism) return false
        if (inputProcessingConfiguration != other.inputProcessingConfiguration) return false
        if (inputSchema != other.inputSchema) return false
        if (kinesisFirehoseInput != other.kinesisFirehoseInput) return false
        if (kinesisStreamsInput != other.kinesisStreamsInput) return false
        if (namePrefix != other.namePrefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalyticsv2.model.Input = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Describes the number of in-application streams to create.
         */
        public var inputParallelism: aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputParallelism? = null
        /**
         * The InputProcessingConfiguration for the input. An input processor transforms records as they are received from the stream, before the application's SQL code executes. Currently, the only input processing configuration available is InputLambdaProcessor.
         */
        public var inputProcessingConfiguration: aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputProcessingConfiguration? = null
        /**
         * Describes the format of the data in the streaming source, and how each data element maps to corresponding columns in the in-application stream that is being created.
         *
         * Also used to describe the format of the reference data source.
         */
        public var inputSchema: aws.sdk.kotlin.services.kinesisanalyticsv2.model.SourceSchema? = null
        /**
         * If the streaming source is an Amazon Kinesis Data Firehose delivery stream, identifies the delivery stream's ARN.
         */
        public var kinesisFirehoseInput: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisFirehoseInput? = null
        /**
         * If the streaming source is an Amazon Kinesis data stream, identifies the stream's Amazon Resource Name (ARN).
         */
        public var kinesisStreamsInput: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisStreamsInput? = null
        /**
         * The name prefix to use when creating an in-application stream. Suppose that you specify a prefix "`MyInApplicationStream`." Kinesis Data Analytics then creates one or more (as per the `InputParallelism` count you specified) in-application streams with the names "`MyInApplicationStream_001`," "`MyInApplicationStream_002`," and so on.
         */
        public var namePrefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalyticsv2.model.Input) : this() {
            this.inputParallelism = x.inputParallelism
            this.inputProcessingConfiguration = x.inputProcessingConfiguration
            this.inputSchema = x.inputSchema
            this.kinesisFirehoseInput = x.kinesisFirehoseInput
            this.kinesisStreamsInput = x.kinesisStreamsInput
            this.namePrefix = x.namePrefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalyticsv2.model.Input = Input(this)

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputParallelism] inside the given [block]
         */
        public fun inputParallelism(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputParallelism.Builder.() -> kotlin.Unit) {
            this.inputParallelism = aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputParallelism.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputProcessingConfiguration] inside the given [block]
         */
        public fun inputProcessingConfiguration(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputProcessingConfiguration.Builder.() -> kotlin.Unit) {
            this.inputProcessingConfiguration = aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputProcessingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.SourceSchema] inside the given [block]
         */
        public fun inputSchema(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.SourceSchema.Builder.() -> kotlin.Unit) {
            this.inputSchema = aws.sdk.kotlin.services.kinesisanalyticsv2.model.SourceSchema.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisFirehoseInput] inside the given [block]
         */
        public fun kinesisFirehoseInput(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisFirehoseInput.Builder.() -> kotlin.Unit) {
            this.kinesisFirehoseInput = aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisFirehoseInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisStreamsInput] inside the given [block]
         */
        public fun kinesisStreamsInput(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisStreamsInput.Builder.() -> kotlin.Unit) {
            this.kinesisStreamsInput = aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisStreamsInput.invoke(block)
        }
    }
}
