// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2.model



/**
 * Describes configuration parameters for a Flink-based Kinesis Data Analytics application or a Studio notebook.
 */
public class FlinkApplicationConfiguration private constructor(builder: Builder) {
    /**
     * Describes an application's checkpointing configuration. Checkpointing is the process of persisting application state for fault tolerance. For more information, see [ Checkpoints for Fault Tolerance](https://ci.apache.org/projects/flink/flink-docs-release-1.8/concepts/programming-model.html#checkpoints-for-fault-tolerance) in the [Apache Flink Documentation](https://ci.apache.org/projects/flink/flink-docs-release-1.8/).
     */
    public val checkpointConfiguration: aws.sdk.kotlin.services.kinesisanalyticsv2.model.CheckpointConfiguration? = builder.checkpointConfiguration
    /**
     * Describes configuration parameters for Amazon CloudWatch logging for an application.
     */
    public val monitoringConfiguration: aws.sdk.kotlin.services.kinesisanalyticsv2.model.MonitoringConfiguration? = builder.monitoringConfiguration
    /**
     * Describes parameters for how an application executes multiple tasks simultaneously.
     */
    public val parallelismConfiguration: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ParallelismConfiguration? = builder.parallelismConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalyticsv2.model.FlinkApplicationConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FlinkApplicationConfiguration(")
        append("checkpointConfiguration=$checkpointConfiguration,")
        append("monitoringConfiguration=$monitoringConfiguration,")
        append("parallelismConfiguration=$parallelismConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = checkpointConfiguration?.hashCode() ?: 0
        result = 31 * result + (monitoringConfiguration?.hashCode() ?: 0)
        result = 31 * result + (parallelismConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FlinkApplicationConfiguration

        if (checkpointConfiguration != other.checkpointConfiguration) return false
        if (monitoringConfiguration != other.monitoringConfiguration) return false
        if (parallelismConfiguration != other.parallelismConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalyticsv2.model.FlinkApplicationConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Describes an application's checkpointing configuration. Checkpointing is the process of persisting application state for fault tolerance. For more information, see [ Checkpoints for Fault Tolerance](https://ci.apache.org/projects/flink/flink-docs-release-1.8/concepts/programming-model.html#checkpoints-for-fault-tolerance) in the [Apache Flink Documentation](https://ci.apache.org/projects/flink/flink-docs-release-1.8/).
         */
        public var checkpointConfiguration: aws.sdk.kotlin.services.kinesisanalyticsv2.model.CheckpointConfiguration? = null
        /**
         * Describes configuration parameters for Amazon CloudWatch logging for an application.
         */
        public var monitoringConfiguration: aws.sdk.kotlin.services.kinesisanalyticsv2.model.MonitoringConfiguration? = null
        /**
         * Describes parameters for how an application executes multiple tasks simultaneously.
         */
        public var parallelismConfiguration: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ParallelismConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalyticsv2.model.FlinkApplicationConfiguration) : this() {
            this.checkpointConfiguration = x.checkpointConfiguration
            this.monitoringConfiguration = x.monitoringConfiguration
            this.parallelismConfiguration = x.parallelismConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalyticsv2.model.FlinkApplicationConfiguration = FlinkApplicationConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.CheckpointConfiguration] inside the given [block]
         */
        public fun checkpointConfiguration(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.CheckpointConfiguration.Builder.() -> kotlin.Unit) {
            this.checkpointConfiguration = aws.sdk.kotlin.services.kinesisanalyticsv2.model.CheckpointConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.MonitoringConfiguration] inside the given [block]
         */
        public fun monitoringConfiguration(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.MonitoringConfiguration.Builder.() -> kotlin.Unit) {
            this.monitoringConfiguration = aws.sdk.kotlin.services.kinesisanalyticsv2.model.MonitoringConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.ParallelismConfiguration] inside the given [block]
         */
        public fun parallelismConfiguration(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ParallelismConfiguration.Builder.() -> kotlin.Unit) {
            this.parallelismConfiguration = aws.sdk.kotlin.services.kinesisanalyticsv2.model.ParallelismConfiguration.invoke(block)
        }
    }
}
