// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2.model



/**
 * Describes updates to the checkpointing parameters for a Flink-based Kinesis Data Analytics application.
 */
public class CheckpointConfigurationUpdate private constructor(builder: Builder) {
    /**
     * Describes updates to the interval in milliseconds between checkpoint operations.
     *
     * If `CheckpointConfiguration.ConfigurationType` is `DEFAULT`, the application will use a `CheckpointInterval` value of 60000, even if this value is set to another value using this API or in application code.
     */
    public val checkpointIntervalUpdate: kotlin.Long? = builder.checkpointIntervalUpdate
    /**
     * Describes updates to whether checkpointing is enabled for an application.
     *
     * If `CheckpointConfiguration.ConfigurationType` is `DEFAULT`, the application will use a `CheckpointingEnabled` value of `true`, even if this value is set to another value using this API or in application code.
     */
    public val checkpointingEnabledUpdate: kotlin.Boolean? = builder.checkpointingEnabledUpdate
    /**
     * Describes updates to whether the application uses the default checkpointing behavior of Kinesis Data Analytics. You must set this property to `CUSTOM` in order to set the `CheckpointingEnabled`, `CheckpointInterval`, or `MinPauseBetweenCheckpoints` parameters.
     *
     * If this value is set to `DEFAULT`, the application will use the following values, even if they are set to other values using APIs or application code:
     * + **CheckpointingEnabled:** true
     * + **CheckpointInterval:** 60000
     * + **MinPauseBetweenCheckpoints:** 5000
     */
    public val configurationTypeUpdate: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ConfigurationType? = builder.configurationTypeUpdate
    /**
     * Describes updates to the minimum time in milliseconds after a checkpoint operation completes that a new checkpoint operation can start.
     *
     * If `CheckpointConfiguration.ConfigurationType` is `DEFAULT`, the application will use a `MinPauseBetweenCheckpoints` value of 5000, even if this value is set using this API or in application code.
     */
    public val minPauseBetweenCheckpointsUpdate: kotlin.Long? = builder.minPauseBetweenCheckpointsUpdate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalyticsv2.model.CheckpointConfigurationUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CheckpointConfigurationUpdate(")
        append("checkpointIntervalUpdate=$checkpointIntervalUpdate,")
        append("checkpointingEnabledUpdate=$checkpointingEnabledUpdate,")
        append("configurationTypeUpdate=$configurationTypeUpdate,")
        append("minPauseBetweenCheckpointsUpdate=$minPauseBetweenCheckpointsUpdate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = checkpointIntervalUpdate?.hashCode() ?: 0
        result = 31 * result + (checkpointingEnabledUpdate?.hashCode() ?: 0)
        result = 31 * result + (configurationTypeUpdate?.hashCode() ?: 0)
        result = 31 * result + (minPauseBetweenCheckpointsUpdate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CheckpointConfigurationUpdate

        if (checkpointIntervalUpdate != other.checkpointIntervalUpdate) return false
        if (checkpointingEnabledUpdate != other.checkpointingEnabledUpdate) return false
        if (configurationTypeUpdate != other.configurationTypeUpdate) return false
        if (minPauseBetweenCheckpointsUpdate != other.minPauseBetweenCheckpointsUpdate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalyticsv2.model.CheckpointConfigurationUpdate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Describes updates to the interval in milliseconds between checkpoint operations.
         *
         * If `CheckpointConfiguration.ConfigurationType` is `DEFAULT`, the application will use a `CheckpointInterval` value of 60000, even if this value is set to another value using this API or in application code.
         */
        public var checkpointIntervalUpdate: kotlin.Long? = null
        /**
         * Describes updates to whether checkpointing is enabled for an application.
         *
         * If `CheckpointConfiguration.ConfigurationType` is `DEFAULT`, the application will use a `CheckpointingEnabled` value of `true`, even if this value is set to another value using this API or in application code.
         */
        public var checkpointingEnabledUpdate: kotlin.Boolean? = null
        /**
         * Describes updates to whether the application uses the default checkpointing behavior of Kinesis Data Analytics. You must set this property to `CUSTOM` in order to set the `CheckpointingEnabled`, `CheckpointInterval`, or `MinPauseBetweenCheckpoints` parameters.
         *
         * If this value is set to `DEFAULT`, the application will use the following values, even if they are set to other values using APIs or application code:
         * + **CheckpointingEnabled:** true
         * + **CheckpointInterval:** 60000
         * + **MinPauseBetweenCheckpoints:** 5000
         */
        public var configurationTypeUpdate: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ConfigurationType? = null
        /**
         * Describes updates to the minimum time in milliseconds after a checkpoint operation completes that a new checkpoint operation can start.
         *
         * If `CheckpointConfiguration.ConfigurationType` is `DEFAULT`, the application will use a `MinPauseBetweenCheckpoints` value of 5000, even if this value is set using this API or in application code.
         */
        public var minPauseBetweenCheckpointsUpdate: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalyticsv2.model.CheckpointConfigurationUpdate) : this() {
            this.checkpointIntervalUpdate = x.checkpointIntervalUpdate
            this.checkpointingEnabledUpdate = x.checkpointingEnabledUpdate
            this.configurationTypeUpdate = x.configurationTypeUpdate
            this.minPauseBetweenCheckpointsUpdate = x.minPauseBetweenCheckpointsUpdate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalyticsv2.model.CheckpointConfigurationUpdate = CheckpointConfigurationUpdate(this)
    }
}
