// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.kinesisanalyticsv2.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.*
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.AddApplicationInputRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.AddApplicationInputResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.AddApplicationOutputRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.AddApplicationOutputResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.AddApplicationVpcConfigurationRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.CreateApplicationPresignedUrlRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.CreateApplicationPresignedUrlResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.CreateApplicationRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.CreateApplicationResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.CreateApplicationSnapshotRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.CreateApplicationSnapshotResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.DeleteApplicationInputProcessingConfigurationRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.DeleteApplicationInputProcessingConfigurationResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.DeleteApplicationOutputRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.DeleteApplicationOutputResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.DeleteApplicationRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.DeleteApplicationResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.DeleteApplicationSnapshotRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.DeleteApplicationSnapshotResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.DescribeApplicationRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.DescribeApplicationResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.DescribeApplicationSnapshotRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.DescribeApplicationSnapshotResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.DescribeApplicationVersionRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.DescribeApplicationVersionResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.DiscoverInputSchemaRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.DiscoverInputSchemaResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.ListApplicationSnapshotsResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.ListApplicationVersionsRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.ListApplicationVersionsResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.ListApplicationsRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.ListApplicationsResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.RollbackApplicationRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.RollbackApplicationResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.StartApplicationRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.StartApplicationResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.StopApplicationRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.StopApplicationResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.TagResourceRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.TagResourceResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.UntagResourceRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.UntagResourceResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationResponse
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.UpdateApplicationRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.UpdateApplicationResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon Kinesis Data Analytics is a fully managed service that you can use to process and analyze streaming data using Java, SQL, or Scala. The service enables you to quickly author and run Java, SQL, or Scala code against streaming sources to perform time series analytics, feed real-time dashboards, and create real-time metrics.
 */
public interface KinesisAnalyticsV2Client : SdkClient {

    override val serviceName: String
        get() = "Kinesis Analytics V2"
    /**
     * KinesisAnalyticsV2Client's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): KinesisAnalyticsV2Client {
            val config = Config.Builder().apply(block).build()
            return DefaultKinesisAnalyticsV2Client(config)
        }

        public operator fun invoke(config: Config): KinesisAnalyticsV2Client = DefaultKinesisAnalyticsV2Client(config)

        /**
         * Construct a [KinesisAnalyticsV2Client] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): KinesisAnalyticsV2Client {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultKinesisAnalyticsV2Client(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds an Amazon CloudWatch log stream to monitor application configuration errors.
     */
    public suspend fun addApplicationCloudWatchLoggingOption(input: AddApplicationCloudWatchLoggingOptionRequest): AddApplicationCloudWatchLoggingOptionResponse

    /**
     * Adds a streaming source to your SQL-based Kinesis Data Analytics application.
     *
     * You can add a streaming source when you create an application, or you can use this operation to add a streaming source after you create an application. For more information, see CreateApplication.
     *
     * Any configuration update, including adding a streaming source using this operation, results in a new version of the application. You can use the DescribeApplication operation to find the current application version.
     */
    public suspend fun addApplicationInput(input: AddApplicationInputRequest): AddApplicationInputResponse

    /**
     * Adds an InputProcessingConfiguration to a SQL-based Kinesis Data Analytics application. An input processor pre-processes records on the input stream before the application's SQL code executes. Currently, the only input processor available is [Amazon Lambda](https://docs.aws.amazon.com/lambda/).
     */
    public suspend fun addApplicationInputProcessingConfiguration(input: AddApplicationInputProcessingConfigurationRequest): AddApplicationInputProcessingConfigurationResponse

    /**
     * Adds an external destination to your SQL-based Kinesis Data Analytics application.
     *
     * If you want Kinesis Data Analytics to deliver data from an in-application stream within your application to an external destination (such as an Kinesis data stream, a Kinesis Data Firehose delivery stream, or an Amazon Lambda function), you add the relevant configuration to your application using this operation. You can configure one or more outputs for your application. Each output configuration maps an in-application stream and an external destination.
     *
     *  You can use one of the output configurations to deliver data from your in-application error stream to an external destination so that you can analyze the errors.
     *
     *  Any configuration update, including adding a streaming source using this operation, results in a new version of the application. You can use the DescribeApplication operation to find the current application version.
     */
    public suspend fun addApplicationOutput(input: AddApplicationOutputRequest): AddApplicationOutputResponse

    /**
     * Adds a reference data source to an existing SQL-based Kinesis Data Analytics application.
     *
     * Kinesis Data Analytics reads reference data (that is, an Amazon S3 object) and creates an in-application table within your application. In the request, you provide the source (S3 bucket name and object key name), name of the in-application table to create, and the necessary mapping information that describes how data in an Amazon S3 object maps to columns in the resulting in-application table.
     */
    public suspend fun addApplicationReferenceDataSource(input: AddApplicationReferenceDataSourceRequest): AddApplicationReferenceDataSourceResponse

    /**
     * Adds a Virtual Private Cloud (VPC) configuration to the application. Applications can use VPCs to store and access resources securely.
     *
     * Note the following about VPC configurations for Kinesis Data Analytics applications:
     * + VPC configurations are not supported for SQL applications.
     * + When a VPC is added to a Kinesis Data Analytics application, the application can no longer be accessed from the Internet directly. To enable Internet access to the application, add an Internet gateway to your VPC.
     */
    public suspend fun addApplicationVpcConfiguration(input: AddApplicationVpcConfigurationRequest): AddApplicationVpcConfigurationResponse

    /**
     * Creates a Kinesis Data Analytics application. For information about creating a Kinesis Data Analytics application, see [Creating an Application](https://docs.aws.amazon.com/kinesisanalytics/latest/java/getting-started.html).
     */
    public suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse

    /**
     * Creates and returns a URL that you can use to connect to an application's extension. Currently, the only available extension is the Apache Flink dashboard.
     *
     * The IAM role or user used to call this API defines the permissions to access the extension. After the presigned URL is created, no additional permission is required to access this URL. IAM authorization policies for this API are also enforced for every HTTP request that attempts to connect to the extension.
     *
     * You control the amount of time that the URL will be valid using the `SessionExpirationDurationInSeconds` parameter. If you do not provide this parameter, the returned URL is valid for twelve hours.
     *
     * The URL that you get from a call to CreateApplicationPresignedUrl must be used within 3 minutes to be valid. If you first try to use the URL after the 3-minute limit expires, the service returns an HTTP 403 Forbidden error.
     */
    public suspend fun createApplicationPresignedUrl(input: CreateApplicationPresignedUrlRequest): CreateApplicationPresignedUrlResponse

    /**
     * Creates a snapshot of the application's state data.
     */
    public suspend fun createApplicationSnapshot(input: CreateApplicationSnapshotRequest): CreateApplicationSnapshotResponse

    /**
     * Deletes the specified application. Kinesis Data Analytics halts application execution and deletes the application.
     */
    public suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse

    /**
     * Deletes an Amazon CloudWatch log stream from an Kinesis Data Analytics application.
     */
    public suspend fun deleteApplicationCloudWatchLoggingOption(input: DeleteApplicationCloudWatchLoggingOptionRequest): DeleteApplicationCloudWatchLoggingOptionResponse

    /**
     * Deletes an InputProcessingConfiguration from an input.
     */
    public suspend fun deleteApplicationInputProcessingConfiguration(input: DeleteApplicationInputProcessingConfigurationRequest): DeleteApplicationInputProcessingConfigurationResponse

    /**
     * Deletes the output destination configuration from your SQL-based Kinesis Data Analytics application's configuration. Kinesis Data Analytics will no longer write data from the corresponding in-application stream to the external output destination.
     */
    public suspend fun deleteApplicationOutput(input: DeleteApplicationOutputRequest): DeleteApplicationOutputResponse

    /**
     * Deletes a reference data source configuration from the specified SQL-based Kinesis Data Analytics application's configuration.
     *
     * If the application is running, Kinesis Data Analytics immediately removes the in-application table that you created using the AddApplicationReferenceDataSource operation.
     */
    public suspend fun deleteApplicationReferenceDataSource(input: DeleteApplicationReferenceDataSourceRequest): DeleteApplicationReferenceDataSourceResponse

    /**
     * Deletes a snapshot of application state.
     */
    public suspend fun deleteApplicationSnapshot(input: DeleteApplicationSnapshotRequest): DeleteApplicationSnapshotResponse

    /**
     * Removes a VPC configuration from a Kinesis Data Analytics application.
     */
    public suspend fun deleteApplicationVpcConfiguration(input: DeleteApplicationVpcConfigurationRequest): DeleteApplicationVpcConfigurationResponse

    /**
     * Returns information about a specific Kinesis Data Analytics application.
     *
     * If you want to retrieve a list of all applications in your account, use the ListApplications operation.
     */
    public suspend fun describeApplication(input: DescribeApplicationRequest): DescribeApplicationResponse

    /**
     * Returns information about a snapshot of application state data.
     */
    public suspend fun describeApplicationSnapshot(input: DescribeApplicationSnapshotRequest): DescribeApplicationSnapshotResponse

    /**
     * Provides a detailed description of a specified version of the application. To see a list of all the versions of an application, invoke the ListApplicationVersions operation.
     *
     * This operation is supported only for Amazon Kinesis Data Analytics for Apache Flink.
     */
    public suspend fun describeApplicationVersion(input: DescribeApplicationVersionRequest): DescribeApplicationVersionResponse

    /**
     * Infers a schema for a SQL-based Kinesis Data Analytics application by evaluating sample records on the specified streaming source (Kinesis data stream or Kinesis Data Firehose delivery stream) or Amazon S3 object. In the response, the operation returns the inferred schema and also the sample records that the operation used to infer the schema.
     *
     *  You can use the inferred schema when configuring a streaming source for your application. When you create an application using the Kinesis Data Analytics console, the console uses this operation to infer a schema and show it in the console user interface.
     */
    public suspend fun discoverInputSchema(input: DiscoverInputSchemaRequest): DiscoverInputSchemaResponse

    /**
     * Lists information about the current application snapshots.
     */
    public suspend fun listApplicationSnapshots(input: ListApplicationSnapshotsRequest): ListApplicationSnapshotsResponse

    /**
     * Lists all the versions for the specified application, including versions that were rolled back. The response also includes a summary of the configuration associated with each version.
     *
     * To get the complete description of a specific application version, invoke the DescribeApplicationVersion operation.
     *
     * This operation is supported only for Amazon Kinesis Data Analytics for Apache Flink.
     */
    public suspend fun listApplicationVersions(input: ListApplicationVersionsRequest): ListApplicationVersionsResponse

    /**
     * Returns a list of Kinesis Data Analytics applications in your account. For each application, the response includes the application name, Amazon Resource Name (ARN), and status.
     *
     * If you want detailed information about a specific application, use DescribeApplication.
     */
    public suspend fun listApplications(input: ListApplicationsRequest = ListApplicationsRequest {}): ListApplicationsResponse

    /**
     * Retrieves the list of key-value tags assigned to the application. For more information, see [Using Tagging](https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html).
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Reverts the application to the previous running version. You can roll back an application if you suspect it is stuck in a transient status.
     *
     * You can roll back an application only if it is in the `UPDATING` or `AUTOSCALING` status.
     *
     * When you rollback an application, it loads state data from the last successful snapshot. If the application has no snapshots, Kinesis Data Analytics rejects the rollback request.
     *
     * This action is not supported for Kinesis Data Analytics for SQL applications.
     */
    public suspend fun rollbackApplication(input: RollbackApplicationRequest): RollbackApplicationResponse

    /**
     * Starts the specified Kinesis Data Analytics application. After creating an application, you must exclusively call this operation to start your application.
     */
    public suspend fun startApplication(input: StartApplicationRequest): StartApplicationResponse

    /**
     * Stops the application from processing data. You can stop an application only if it is in the running status, unless you set the `Force` parameter to `true`.
     *
     * You can use the DescribeApplication operation to find the application status.
     *
     * Kinesis Data Analytics takes a snapshot when the application is stopped, unless `Force` is set to `true`.
     */
    public suspend fun stopApplication(input: StopApplicationRequest): StopApplicationResponse

    /**
     * Adds one or more key-value tags to a Kinesis Data Analytics application. Note that the maximum number of application tags includes system tags. The maximum number of user-defined application tags is 50. For more information, see [Using Tagging](https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html).
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from a Kinesis Data Analytics application. For more information, see [Using Tagging](https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html).
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an existing Kinesis Data Analytics application. Using this operation, you can update application code, input configuration, and output configuration.
     *
     * Kinesis Data Analytics updates the `ApplicationVersionId` each time you update your application.
     *
     * You cannot update the `RuntimeEnvironment` of an existing application. If you need to update an application's `RuntimeEnvironment`, you must delete the application and create it again.
     */
    public suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse

    /**
     * Updates the maintenance configuration of the Kinesis Data Analytics application.
     *
     * You can invoke this operation on an application that is in one of the two following states: `READY` or `RUNNING`. If you invoke it when the application is in a state other than these two states, it throws a `ResourceInUseException`. The service makes use of the updated configuration the next time it schedules maintenance for the application. If you invoke this operation after the service schedules maintenance, the service will apply the configuration update the next time it schedules maintenance for the application. This means that you might not see the maintenance configuration update applied to the maintenance process that follows a successful invocation of this operation, but to the following maintenance process instead.
     *
     * To see the current maintenance configuration of your application, invoke the DescribeApplication operation.
     *
     * For information about application maintenance, see [Kinesis Data Analytics for Apache Flink Maintenance](https://docs.aws.amazon.com/kinesisanalytics/latest/java/maintenance.html).
     *
     * This operation is supported only for Amazon Kinesis Data Analytics for Apache Flink.
     */
    public suspend fun updateApplicationMaintenanceConfiguration(input: UpdateApplicationMaintenanceConfigurationRequest): UpdateApplicationMaintenanceConfigurationResponse
}

/**
 * Adds an Amazon CloudWatch log stream to monitor application configuration errors.
 */
public suspend inline fun KinesisAnalyticsV2Client.addApplicationCloudWatchLoggingOption(crossinline block: AddApplicationCloudWatchLoggingOptionRequest.Builder.() -> Unit): AddApplicationCloudWatchLoggingOptionResponse = addApplicationCloudWatchLoggingOption(AddApplicationCloudWatchLoggingOptionRequest.Builder().apply(block).build())

/**
 * Adds a streaming source to your SQL-based Kinesis Data Analytics application.
 *
 * You can add a streaming source when you create an application, or you can use this operation to add a streaming source after you create an application. For more information, see CreateApplication.
 *
 * Any configuration update, including adding a streaming source using this operation, results in a new version of the application. You can use the DescribeApplication operation to find the current application version.
 */
public suspend inline fun KinesisAnalyticsV2Client.addApplicationInput(crossinline block: AddApplicationInputRequest.Builder.() -> Unit): AddApplicationInputResponse = addApplicationInput(AddApplicationInputRequest.Builder().apply(block).build())

/**
 * Adds an InputProcessingConfiguration to a SQL-based Kinesis Data Analytics application. An input processor pre-processes records on the input stream before the application's SQL code executes. Currently, the only input processor available is [Amazon Lambda](https://docs.aws.amazon.com/lambda/).
 */
public suspend inline fun KinesisAnalyticsV2Client.addApplicationInputProcessingConfiguration(crossinline block: AddApplicationInputProcessingConfigurationRequest.Builder.() -> Unit): AddApplicationInputProcessingConfigurationResponse = addApplicationInputProcessingConfiguration(AddApplicationInputProcessingConfigurationRequest.Builder().apply(block).build())

/**
 * Adds an external destination to your SQL-based Kinesis Data Analytics application.
 *
 * If you want Kinesis Data Analytics to deliver data from an in-application stream within your application to an external destination (such as an Kinesis data stream, a Kinesis Data Firehose delivery stream, or an Amazon Lambda function), you add the relevant configuration to your application using this operation. You can configure one or more outputs for your application. Each output configuration maps an in-application stream and an external destination.
 *
 *  You can use one of the output configurations to deliver data from your in-application error stream to an external destination so that you can analyze the errors.
 *
 *  Any configuration update, including adding a streaming source using this operation, results in a new version of the application. You can use the DescribeApplication operation to find the current application version.
 */
public suspend inline fun KinesisAnalyticsV2Client.addApplicationOutput(crossinline block: AddApplicationOutputRequest.Builder.() -> Unit): AddApplicationOutputResponse = addApplicationOutput(AddApplicationOutputRequest.Builder().apply(block).build())

/**
 * Adds a reference data source to an existing SQL-based Kinesis Data Analytics application.
 *
 * Kinesis Data Analytics reads reference data (that is, an Amazon S3 object) and creates an in-application table within your application. In the request, you provide the source (S3 bucket name and object key name), name of the in-application table to create, and the necessary mapping information that describes how data in an Amazon S3 object maps to columns in the resulting in-application table.
 */
public suspend inline fun KinesisAnalyticsV2Client.addApplicationReferenceDataSource(crossinline block: AddApplicationReferenceDataSourceRequest.Builder.() -> Unit): AddApplicationReferenceDataSourceResponse = addApplicationReferenceDataSource(AddApplicationReferenceDataSourceRequest.Builder().apply(block).build())

/**
 * Adds a Virtual Private Cloud (VPC) configuration to the application. Applications can use VPCs to store and access resources securely.
 *
 * Note the following about VPC configurations for Kinesis Data Analytics applications:
 * + VPC configurations are not supported for SQL applications.
 * + When a VPC is added to a Kinesis Data Analytics application, the application can no longer be accessed from the Internet directly. To enable Internet access to the application, add an Internet gateway to your VPC.
 */
public suspend inline fun KinesisAnalyticsV2Client.addApplicationVpcConfiguration(crossinline block: AddApplicationVpcConfigurationRequest.Builder.() -> Unit): AddApplicationVpcConfigurationResponse = addApplicationVpcConfiguration(AddApplicationVpcConfigurationRequest.Builder().apply(block).build())

/**
 * Creates a Kinesis Data Analytics application. For information about creating a Kinesis Data Analytics application, see [Creating an Application](https://docs.aws.amazon.com/kinesisanalytics/latest/java/getting-started.html).
 */
public suspend inline fun KinesisAnalyticsV2Client.createApplication(crossinline block: CreateApplicationRequest.Builder.() -> Unit): CreateApplicationResponse = createApplication(CreateApplicationRequest.Builder().apply(block).build())

/**
 * Creates and returns a URL that you can use to connect to an application's extension. Currently, the only available extension is the Apache Flink dashboard.
 *
 * The IAM role or user used to call this API defines the permissions to access the extension. After the presigned URL is created, no additional permission is required to access this URL. IAM authorization policies for this API are also enforced for every HTTP request that attempts to connect to the extension.
 *
 * You control the amount of time that the URL will be valid using the `SessionExpirationDurationInSeconds` parameter. If you do not provide this parameter, the returned URL is valid for twelve hours.
 *
 * The URL that you get from a call to CreateApplicationPresignedUrl must be used within 3 minutes to be valid. If you first try to use the URL after the 3-minute limit expires, the service returns an HTTP 403 Forbidden error.
 */
public suspend inline fun KinesisAnalyticsV2Client.createApplicationPresignedUrl(crossinline block: CreateApplicationPresignedUrlRequest.Builder.() -> Unit): CreateApplicationPresignedUrlResponse = createApplicationPresignedUrl(CreateApplicationPresignedUrlRequest.Builder().apply(block).build())

/**
 * Creates a snapshot of the application's state data.
 */
public suspend inline fun KinesisAnalyticsV2Client.createApplicationSnapshot(crossinline block: CreateApplicationSnapshotRequest.Builder.() -> Unit): CreateApplicationSnapshotResponse = createApplicationSnapshot(CreateApplicationSnapshotRequest.Builder().apply(block).build())

/**
 * Deletes the specified application. Kinesis Data Analytics halts application execution and deletes the application.
 */
public suspend inline fun KinesisAnalyticsV2Client.deleteApplication(crossinline block: DeleteApplicationRequest.Builder.() -> Unit): DeleteApplicationResponse = deleteApplication(DeleteApplicationRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon CloudWatch log stream from an Kinesis Data Analytics application.
 */
public suspend inline fun KinesisAnalyticsV2Client.deleteApplicationCloudWatchLoggingOption(crossinline block: DeleteApplicationCloudWatchLoggingOptionRequest.Builder.() -> Unit): DeleteApplicationCloudWatchLoggingOptionResponse = deleteApplicationCloudWatchLoggingOption(DeleteApplicationCloudWatchLoggingOptionRequest.Builder().apply(block).build())

/**
 * Deletes an InputProcessingConfiguration from an input.
 */
public suspend inline fun KinesisAnalyticsV2Client.deleteApplicationInputProcessingConfiguration(crossinline block: DeleteApplicationInputProcessingConfigurationRequest.Builder.() -> Unit): DeleteApplicationInputProcessingConfigurationResponse = deleteApplicationInputProcessingConfiguration(DeleteApplicationInputProcessingConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes the output destination configuration from your SQL-based Kinesis Data Analytics application's configuration. Kinesis Data Analytics will no longer write data from the corresponding in-application stream to the external output destination.
 */
public suspend inline fun KinesisAnalyticsV2Client.deleteApplicationOutput(crossinline block: DeleteApplicationOutputRequest.Builder.() -> Unit): DeleteApplicationOutputResponse = deleteApplicationOutput(DeleteApplicationOutputRequest.Builder().apply(block).build())

/**
 * Deletes a reference data source configuration from the specified SQL-based Kinesis Data Analytics application's configuration.
 *
 * If the application is running, Kinesis Data Analytics immediately removes the in-application table that you created using the AddApplicationReferenceDataSource operation.
 */
public suspend inline fun KinesisAnalyticsV2Client.deleteApplicationReferenceDataSource(crossinline block: DeleteApplicationReferenceDataSourceRequest.Builder.() -> Unit): DeleteApplicationReferenceDataSourceResponse = deleteApplicationReferenceDataSource(DeleteApplicationReferenceDataSourceRequest.Builder().apply(block).build())

/**
 * Deletes a snapshot of application state.
 */
public suspend inline fun KinesisAnalyticsV2Client.deleteApplicationSnapshot(crossinline block: DeleteApplicationSnapshotRequest.Builder.() -> Unit): DeleteApplicationSnapshotResponse = deleteApplicationSnapshot(DeleteApplicationSnapshotRequest.Builder().apply(block).build())

/**
 * Removes a VPC configuration from a Kinesis Data Analytics application.
 */
public suspend inline fun KinesisAnalyticsV2Client.deleteApplicationVpcConfiguration(crossinline block: DeleteApplicationVpcConfigurationRequest.Builder.() -> Unit): DeleteApplicationVpcConfigurationResponse = deleteApplicationVpcConfiguration(DeleteApplicationVpcConfigurationRequest.Builder().apply(block).build())

/**
 * Returns information about a specific Kinesis Data Analytics application.
 *
 * If you want to retrieve a list of all applications in your account, use the ListApplications operation.
 */
public suspend inline fun KinesisAnalyticsV2Client.describeApplication(crossinline block: DescribeApplicationRequest.Builder.() -> Unit): DescribeApplicationResponse = describeApplication(DescribeApplicationRequest.Builder().apply(block).build())

/**
 * Returns information about a snapshot of application state data.
 */
public suspend inline fun KinesisAnalyticsV2Client.describeApplicationSnapshot(crossinline block: DescribeApplicationSnapshotRequest.Builder.() -> Unit): DescribeApplicationSnapshotResponse = describeApplicationSnapshot(DescribeApplicationSnapshotRequest.Builder().apply(block).build())

/**
 * Provides a detailed description of a specified version of the application. To see a list of all the versions of an application, invoke the ListApplicationVersions operation.
 *
 * This operation is supported only for Amazon Kinesis Data Analytics for Apache Flink.
 */
public suspend inline fun KinesisAnalyticsV2Client.describeApplicationVersion(crossinline block: DescribeApplicationVersionRequest.Builder.() -> Unit): DescribeApplicationVersionResponse = describeApplicationVersion(DescribeApplicationVersionRequest.Builder().apply(block).build())

/**
 * Infers a schema for a SQL-based Kinesis Data Analytics application by evaluating sample records on the specified streaming source (Kinesis data stream or Kinesis Data Firehose delivery stream) or Amazon S3 object. In the response, the operation returns the inferred schema and also the sample records that the operation used to infer the schema.
 *
 *  You can use the inferred schema when configuring a streaming source for your application. When you create an application using the Kinesis Data Analytics console, the console uses this operation to infer a schema and show it in the console user interface.
 */
public suspend inline fun KinesisAnalyticsV2Client.discoverInputSchema(crossinline block: DiscoverInputSchemaRequest.Builder.() -> Unit): DiscoverInputSchemaResponse = discoverInputSchema(DiscoverInputSchemaRequest.Builder().apply(block).build())

/**
 * Lists information about the current application snapshots.
 */
public suspend inline fun KinesisAnalyticsV2Client.listApplicationSnapshots(crossinline block: ListApplicationSnapshotsRequest.Builder.() -> Unit): ListApplicationSnapshotsResponse = listApplicationSnapshots(ListApplicationSnapshotsRequest.Builder().apply(block).build())

/**
 * Lists all the versions for the specified application, including versions that were rolled back. The response also includes a summary of the configuration associated with each version.
 *
 * To get the complete description of a specific application version, invoke the DescribeApplicationVersion operation.
 *
 * This operation is supported only for Amazon Kinesis Data Analytics for Apache Flink.
 */
public suspend inline fun KinesisAnalyticsV2Client.listApplicationVersions(crossinline block: ListApplicationVersionsRequest.Builder.() -> Unit): ListApplicationVersionsResponse = listApplicationVersions(ListApplicationVersionsRequest.Builder().apply(block).build())

/**
 * Returns a list of Kinesis Data Analytics applications in your account. For each application, the response includes the application name, Amazon Resource Name (ARN), and status.
 *
 * If you want detailed information about a specific application, use DescribeApplication.
 */
public suspend inline fun KinesisAnalyticsV2Client.listApplications(crossinline block: ListApplicationsRequest.Builder.() -> Unit): ListApplicationsResponse = listApplications(ListApplicationsRequest.Builder().apply(block).build())

/**
 * Retrieves the list of key-value tags assigned to the application. For more information, see [Using Tagging](https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html).
 */
public suspend inline fun KinesisAnalyticsV2Client.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Reverts the application to the previous running version. You can roll back an application if you suspect it is stuck in a transient status.
 *
 * You can roll back an application only if it is in the `UPDATING` or `AUTOSCALING` status.
 *
 * When you rollback an application, it loads state data from the last successful snapshot. If the application has no snapshots, Kinesis Data Analytics rejects the rollback request.
 *
 * This action is not supported for Kinesis Data Analytics for SQL applications.
 */
public suspend inline fun KinesisAnalyticsV2Client.rollbackApplication(crossinline block: RollbackApplicationRequest.Builder.() -> Unit): RollbackApplicationResponse = rollbackApplication(RollbackApplicationRequest.Builder().apply(block).build())

/**
 * Starts the specified Kinesis Data Analytics application. After creating an application, you must exclusively call this operation to start your application.
 */
public suspend inline fun KinesisAnalyticsV2Client.startApplication(crossinline block: StartApplicationRequest.Builder.() -> Unit): StartApplicationResponse = startApplication(StartApplicationRequest.Builder().apply(block).build())

/**
 * Stops the application from processing data. You can stop an application only if it is in the running status, unless you set the `Force` parameter to `true`.
 *
 * You can use the DescribeApplication operation to find the application status.
 *
 * Kinesis Data Analytics takes a snapshot when the application is stopped, unless `Force` is set to `true`.
 */
public suspend inline fun KinesisAnalyticsV2Client.stopApplication(crossinline block: StopApplicationRequest.Builder.() -> Unit): StopApplicationResponse = stopApplication(StopApplicationRequest.Builder().apply(block).build())

/**
 * Adds one or more key-value tags to a Kinesis Data Analytics application. Note that the maximum number of application tags includes system tags. The maximum number of user-defined application tags is 50. For more information, see [Using Tagging](https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html).
 */
public suspend inline fun KinesisAnalyticsV2Client.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from a Kinesis Data Analytics application. For more information, see [Using Tagging](https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html).
 */
public suspend inline fun KinesisAnalyticsV2Client.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an existing Kinesis Data Analytics application. Using this operation, you can update application code, input configuration, and output configuration.
 *
 * Kinesis Data Analytics updates the `ApplicationVersionId` each time you update your application.
 *
 * You cannot update the `RuntimeEnvironment` of an existing application. If you need to update an application's `RuntimeEnvironment`, you must delete the application and create it again.
 */
public suspend inline fun KinesisAnalyticsV2Client.updateApplication(crossinline block: UpdateApplicationRequest.Builder.() -> Unit): UpdateApplicationResponse = updateApplication(UpdateApplicationRequest.Builder().apply(block).build())

/**
 * Updates the maintenance configuration of the Kinesis Data Analytics application.
 *
 * You can invoke this operation on an application that is in one of the two following states: `READY` or `RUNNING`. If you invoke it when the application is in a state other than these two states, it throws a `ResourceInUseException`. The service makes use of the updated configuration the next time it schedules maintenance for the application. If you invoke this operation after the service schedules maintenance, the service will apply the configuration update the next time it schedules maintenance for the application. This means that you might not see the maintenance configuration update applied to the maintenance process that follows a successful invocation of this operation, but to the following maintenance process instead.
 *
 * To see the current maintenance configuration of your application, invoke the DescribeApplication operation.
 *
 * For information about application maintenance, see [Kinesis Data Analytics for Apache Flink Maintenance](https://docs.aws.amazon.com/kinesisanalytics/latest/java/maintenance.html).
 *
 * This operation is supported only for Amazon Kinesis Data Analytics for Apache Flink.
 */
public suspend inline fun KinesisAnalyticsV2Client.updateApplicationMaintenanceConfiguration(crossinline block: UpdateApplicationMaintenanceConfigurationRequest.Builder.() -> Unit): UpdateApplicationMaintenanceConfigurationResponse = updateApplicationMaintenanceConfiguration(UpdateApplicationMaintenanceConfigurationRequest.Builder().apply(block).build())
