// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.*
import aws.sdk.kotlin.services.kinesisanalyticsv2.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "Kinesis Analytics V2"
public const val ServiceApiVersion: String = "2018-05-23"
public const val SdkVersion: String = "0.17.1-beta"

internal class DefaultKinesisAnalyticsV2Client(override val config: KinesisAnalyticsV2Client.Config) : KinesisAnalyticsV2Client {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Adds an Amazon CloudWatch log stream to monitor application configuration errors.
     */
    override suspend fun addApplicationCloudWatchLoggingOption(input: AddApplicationCloudWatchLoggingOptionRequest): AddApplicationCloudWatchLoggingOptionResponse {
        val op = SdkHttpOperation.build<AddApplicationCloudWatchLoggingOptionRequest, AddApplicationCloudWatchLoggingOptionResponse> {
            serializer = AddApplicationCloudWatchLoggingOptionOperationSerializer()
            deserializer = AddApplicationCloudWatchLoggingOptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddApplicationCloudWatchLoggingOption"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds a streaming source to your SQL-based Kinesis Data Analytics application.
     *
     * You can add a streaming source when you create an application, or you can use this operation to add a streaming source after you create an application. For more information, see CreateApplication.
     *
     * Any configuration update, including adding a streaming source using this operation, results in a new version of the application. You can use the DescribeApplication operation to find the current application version.
     */
    override suspend fun addApplicationInput(input: AddApplicationInputRequest): AddApplicationInputResponse {
        val op = SdkHttpOperation.build<AddApplicationInputRequest, AddApplicationInputResponse> {
            serializer = AddApplicationInputOperationSerializer()
            deserializer = AddApplicationInputOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddApplicationInput"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds an InputProcessingConfiguration to a SQL-based Kinesis Data Analytics application. An input processor pre-processes records on the input stream before the application's SQL code executes. Currently, the only input processor available is [Amazon Lambda](https://docs.aws.amazon.com/lambda/).
     */
    override suspend fun addApplicationInputProcessingConfiguration(input: AddApplicationInputProcessingConfigurationRequest): AddApplicationInputProcessingConfigurationResponse {
        val op = SdkHttpOperation.build<AddApplicationInputProcessingConfigurationRequest, AddApplicationInputProcessingConfigurationResponse> {
            serializer = AddApplicationInputProcessingConfigurationOperationSerializer()
            deserializer = AddApplicationInputProcessingConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddApplicationInputProcessingConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds an external destination to your SQL-based Kinesis Data Analytics application.
     *
     * If you want Kinesis Data Analytics to deliver data from an in-application stream within your application to an external destination (such as an Kinesis data stream, a Kinesis Data Firehose delivery stream, or an Amazon Lambda function), you add the relevant configuration to your application using this operation. You can configure one or more outputs for your application. Each output configuration maps an in-application stream and an external destination.
     *
     *  You can use one of the output configurations to deliver data from your in-application error stream to an external destination so that you can analyze the errors.
     *
     *  Any configuration update, including adding a streaming source using this operation, results in a new version of the application. You can use the DescribeApplication operation to find the current application version.
     */
    override suspend fun addApplicationOutput(input: AddApplicationOutputRequest): AddApplicationOutputResponse {
        val op = SdkHttpOperation.build<AddApplicationOutputRequest, AddApplicationOutputResponse> {
            serializer = AddApplicationOutputOperationSerializer()
            deserializer = AddApplicationOutputOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddApplicationOutput"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds a reference data source to an existing SQL-based Kinesis Data Analytics application.
     *
     * Kinesis Data Analytics reads reference data (that is, an Amazon S3 object) and creates an in-application table within your application. In the request, you provide the source (S3 bucket name and object key name), name of the in-application table to create, and the necessary mapping information that describes how data in an Amazon S3 object maps to columns in the resulting in-application table.
     */
    override suspend fun addApplicationReferenceDataSource(input: AddApplicationReferenceDataSourceRequest): AddApplicationReferenceDataSourceResponse {
        val op = SdkHttpOperation.build<AddApplicationReferenceDataSourceRequest, AddApplicationReferenceDataSourceResponse> {
            serializer = AddApplicationReferenceDataSourceOperationSerializer()
            deserializer = AddApplicationReferenceDataSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddApplicationReferenceDataSource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds a Virtual Private Cloud (VPC) configuration to the application. Applications can use VPCs to store and access resources securely.
     *
     * Note the following about VPC configurations for Kinesis Data Analytics applications:
     * + VPC configurations are not supported for SQL applications.
     * + When a VPC is added to a Kinesis Data Analytics application, the application can no longer be accessed from the Internet directly. To enable Internet access to the application, add an Internet gateway to your VPC.
     */
    override suspend fun addApplicationVpcConfiguration(input: AddApplicationVpcConfigurationRequest): AddApplicationVpcConfigurationResponse {
        val op = SdkHttpOperation.build<AddApplicationVpcConfigurationRequest, AddApplicationVpcConfigurationResponse> {
            serializer = AddApplicationVpcConfigurationOperationSerializer()
            deserializer = AddApplicationVpcConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddApplicationVpcConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Kinesis Data Analytics application. For information about creating a Kinesis Data Analytics application, see [Creating an Application](https://docs.aws.amazon.com/kinesisanalytics/latest/java/getting-started.html).
     */
    override suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse {
        val op = SdkHttpOperation.build<CreateApplicationRequest, CreateApplicationResponse> {
            serializer = CreateApplicationOperationSerializer()
            deserializer = CreateApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates and returns a URL that you can use to connect to an application's extension. Currently, the only available extension is the Apache Flink dashboard.
     *
     * The IAM role or user used to call this API defines the permissions to access the extension. After the presigned URL is created, no additional permission is required to access this URL. IAM authorization policies for this API are also enforced for every HTTP request that attempts to connect to the extension.
     *
     * You control the amount of time that the URL will be valid using the `SessionExpirationDurationInSeconds` parameter. If you do not provide this parameter, the returned URL is valid for twelve hours.
     *
     * The URL that you get from a call to CreateApplicationPresignedUrl must be used within 3 minutes to be valid. If you first try to use the URL after the 3-minute limit expires, the service returns an HTTP 403 Forbidden error.
     */
    override suspend fun createApplicationPresignedUrl(input: CreateApplicationPresignedUrlRequest): CreateApplicationPresignedUrlResponse {
        val op = SdkHttpOperation.build<CreateApplicationPresignedUrlRequest, CreateApplicationPresignedUrlResponse> {
            serializer = CreateApplicationPresignedUrlOperationSerializer()
            deserializer = CreateApplicationPresignedUrlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateApplicationPresignedUrl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a snapshot of the application's state data.
     */
    override suspend fun createApplicationSnapshot(input: CreateApplicationSnapshotRequest): CreateApplicationSnapshotResponse {
        val op = SdkHttpOperation.build<CreateApplicationSnapshotRequest, CreateApplicationSnapshotResponse> {
            serializer = CreateApplicationSnapshotOperationSerializer()
            deserializer = CreateApplicationSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateApplicationSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified application. Kinesis Data Analytics halts application execution and deletes the application.
     */
    override suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse {
        val op = SdkHttpOperation.build<DeleteApplicationRequest, DeleteApplicationResponse> {
            serializer = DeleteApplicationOperationSerializer()
            deserializer = DeleteApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Amazon CloudWatch log stream from an Kinesis Data Analytics application.
     */
    override suspend fun deleteApplicationCloudWatchLoggingOption(input: DeleteApplicationCloudWatchLoggingOptionRequest): DeleteApplicationCloudWatchLoggingOptionResponse {
        val op = SdkHttpOperation.build<DeleteApplicationCloudWatchLoggingOptionRequest, DeleteApplicationCloudWatchLoggingOptionResponse> {
            serializer = DeleteApplicationCloudWatchLoggingOptionOperationSerializer()
            deserializer = DeleteApplicationCloudWatchLoggingOptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteApplicationCloudWatchLoggingOption"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an InputProcessingConfiguration from an input.
     */
    override suspend fun deleteApplicationInputProcessingConfiguration(input: DeleteApplicationInputProcessingConfigurationRequest): DeleteApplicationInputProcessingConfigurationResponse {
        val op = SdkHttpOperation.build<DeleteApplicationInputProcessingConfigurationRequest, DeleteApplicationInputProcessingConfigurationResponse> {
            serializer = DeleteApplicationInputProcessingConfigurationOperationSerializer()
            deserializer = DeleteApplicationInputProcessingConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteApplicationInputProcessingConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the output destination configuration from your SQL-based Kinesis Data Analytics application's configuration. Kinesis Data Analytics will no longer write data from the corresponding in-application stream to the external output destination.
     */
    override suspend fun deleteApplicationOutput(input: DeleteApplicationOutputRequest): DeleteApplicationOutputResponse {
        val op = SdkHttpOperation.build<DeleteApplicationOutputRequest, DeleteApplicationOutputResponse> {
            serializer = DeleteApplicationOutputOperationSerializer()
            deserializer = DeleteApplicationOutputOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteApplicationOutput"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a reference data source configuration from the specified SQL-based Kinesis Data Analytics application's configuration.
     *
     * If the application is running, Kinesis Data Analytics immediately removes the in-application table that you created using the AddApplicationReferenceDataSource operation.
     */
    override suspend fun deleteApplicationReferenceDataSource(input: DeleteApplicationReferenceDataSourceRequest): DeleteApplicationReferenceDataSourceResponse {
        val op = SdkHttpOperation.build<DeleteApplicationReferenceDataSourceRequest, DeleteApplicationReferenceDataSourceResponse> {
            serializer = DeleteApplicationReferenceDataSourceOperationSerializer()
            deserializer = DeleteApplicationReferenceDataSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteApplicationReferenceDataSource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a snapshot of application state.
     */
    override suspend fun deleteApplicationSnapshot(input: DeleteApplicationSnapshotRequest): DeleteApplicationSnapshotResponse {
        val op = SdkHttpOperation.build<DeleteApplicationSnapshotRequest, DeleteApplicationSnapshotResponse> {
            serializer = DeleteApplicationSnapshotOperationSerializer()
            deserializer = DeleteApplicationSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteApplicationSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a VPC configuration from a Kinesis Data Analytics application.
     */
    override suspend fun deleteApplicationVpcConfiguration(input: DeleteApplicationVpcConfigurationRequest): DeleteApplicationVpcConfigurationResponse {
        val op = SdkHttpOperation.build<DeleteApplicationVpcConfigurationRequest, DeleteApplicationVpcConfigurationResponse> {
            serializer = DeleteApplicationVpcConfigurationOperationSerializer()
            deserializer = DeleteApplicationVpcConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteApplicationVpcConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a specific Kinesis Data Analytics application.
     *
     * If you want to retrieve a list of all applications in your account, use the ListApplications operation.
     */
    override suspend fun describeApplication(input: DescribeApplicationRequest): DescribeApplicationResponse {
        val op = SdkHttpOperation.build<DescribeApplicationRequest, DescribeApplicationResponse> {
            serializer = DescribeApplicationOperationSerializer()
            deserializer = DescribeApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a snapshot of application state data.
     */
    override suspend fun describeApplicationSnapshot(input: DescribeApplicationSnapshotRequest): DescribeApplicationSnapshotResponse {
        val op = SdkHttpOperation.build<DescribeApplicationSnapshotRequest, DescribeApplicationSnapshotResponse> {
            serializer = DescribeApplicationSnapshotOperationSerializer()
            deserializer = DescribeApplicationSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeApplicationSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides a detailed description of a specified version of the application. To see a list of all the versions of an application, invoke the ListApplicationVersions operation.
     *
     * This operation is supported only for Amazon Kinesis Data Analytics for Apache Flink.
     */
    override suspend fun describeApplicationVersion(input: DescribeApplicationVersionRequest): DescribeApplicationVersionResponse {
        val op = SdkHttpOperation.build<DescribeApplicationVersionRequest, DescribeApplicationVersionResponse> {
            serializer = DescribeApplicationVersionOperationSerializer()
            deserializer = DescribeApplicationVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeApplicationVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Infers a schema for a SQL-based Kinesis Data Analytics application by evaluating sample records on the specified streaming source (Kinesis data stream or Kinesis Data Firehose delivery stream) or Amazon S3 object. In the response, the operation returns the inferred schema and also the sample records that the operation used to infer the schema.
     *
     *  You can use the inferred schema when configuring a streaming source for your application. When you create an application using the Kinesis Data Analytics console, the console uses this operation to infer a schema and show it in the console user interface.
     */
    override suspend fun discoverInputSchema(input: DiscoverInputSchemaRequest): DiscoverInputSchemaResponse {
        val op = SdkHttpOperation.build<DiscoverInputSchemaRequest, DiscoverInputSchemaResponse> {
            serializer = DiscoverInputSchemaOperationSerializer()
            deserializer = DiscoverInputSchemaOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DiscoverInputSchema"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists information about the current application snapshots.
     */
    override suspend fun listApplicationSnapshots(input: ListApplicationSnapshotsRequest): ListApplicationSnapshotsResponse {
        val op = SdkHttpOperation.build<ListApplicationSnapshotsRequest, ListApplicationSnapshotsResponse> {
            serializer = ListApplicationSnapshotsOperationSerializer()
            deserializer = ListApplicationSnapshotsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListApplicationSnapshots"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the versions for the specified application, including versions that were rolled back. The response also includes a summary of the configuration associated with each version.
     *
     * To get the complete description of a specific application version, invoke the DescribeApplicationVersion operation.
     *
     * This operation is supported only for Amazon Kinesis Data Analytics for Apache Flink.
     */
    override suspend fun listApplicationVersions(input: ListApplicationVersionsRequest): ListApplicationVersionsResponse {
        val op = SdkHttpOperation.build<ListApplicationVersionsRequest, ListApplicationVersionsResponse> {
            serializer = ListApplicationVersionsOperationSerializer()
            deserializer = ListApplicationVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListApplicationVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of Kinesis Data Analytics applications in your account. For each application, the response includes the application name, Amazon Resource Name (ARN), and status.
     *
     * If you want detailed information about a specific application, use DescribeApplication.
     */
    override suspend fun listApplications(input: ListApplicationsRequest): ListApplicationsResponse {
        val op = SdkHttpOperation.build<ListApplicationsRequest, ListApplicationsResponse> {
            serializer = ListApplicationsOperationSerializer()
            deserializer = ListApplicationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListApplications"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the list of key-value tags assigned to the application. For more information, see [Using Tagging](https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html).
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Reverts the application to the previous running version. You can roll back an application if you suspect it is stuck in a transient status.
     *
     * You can roll back an application only if it is in the `UPDATING` or `AUTOSCALING` status.
     *
     * When you rollback an application, it loads state data from the last successful snapshot. If the application has no snapshots, Kinesis Data Analytics rejects the rollback request.
     *
     * This action is not supported for Kinesis Data Analytics for SQL applications.
     */
    override suspend fun rollbackApplication(input: RollbackApplicationRequest): RollbackApplicationResponse {
        val op = SdkHttpOperation.build<RollbackApplicationRequest, RollbackApplicationResponse> {
            serializer = RollbackApplicationOperationSerializer()
            deserializer = RollbackApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RollbackApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts the specified Kinesis Data Analytics application. After creating an application, you must exclusively call this operation to start your application.
     */
    override suspend fun startApplication(input: StartApplicationRequest): StartApplicationResponse {
        val op = SdkHttpOperation.build<StartApplicationRequest, StartApplicationResponse> {
            serializer = StartApplicationOperationSerializer()
            deserializer = StartApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops the application from processing data. You can stop an application only if it is in the running status, unless you set the `Force` parameter to `true`.
     *
     * You can use the DescribeApplication operation to find the application status.
     *
     * Kinesis Data Analytics takes a snapshot when the application is stopped, unless `Force` is set to `true`.
     */
    override suspend fun stopApplication(input: StopApplicationRequest): StopApplicationResponse {
        val op = SdkHttpOperation.build<StopApplicationRequest, StopApplicationResponse> {
            serializer = StopApplicationOperationSerializer()
            deserializer = StopApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds one or more key-value tags to a Kinesis Data Analytics application. Note that the maximum number of application tags includes system tags. The maximum number of user-defined application tags is 50. For more information, see [Using Tagging](https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html).
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more tags from a Kinesis Data Analytics application. For more information, see [Using Tagging](https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html).
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing Kinesis Data Analytics application. Using this operation, you can update application code, input configuration, and output configuration.
     *
     * Kinesis Data Analytics updates the `ApplicationVersionId` each time you update your application.
     *
     * You cannot update the `RuntimeEnvironment` of an existing application. If you need to update an application's `RuntimeEnvironment`, you must delete the application and create it again.
     */
    override suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse {
        val op = SdkHttpOperation.build<UpdateApplicationRequest, UpdateApplicationResponse> {
            serializer = UpdateApplicationOperationSerializer()
            deserializer = UpdateApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the maintenance configuration of the Kinesis Data Analytics application.
     *
     * You can invoke this operation on an application that is in one of the two following states: `READY` or `RUNNING`. If you invoke it when the application is in a state other than these two states, it throws a `ResourceInUseException`. The service makes use of the updated configuration the next time it schedules maintenance for the application. If you invoke this operation after the service schedules maintenance, the service will apply the configuration update the next time it schedules maintenance for the application. This means that you might not see the maintenance configuration update applied to the maintenance process that follows a successful invocation of this operation, but to the following maintenance process instead.
     *
     * To see the current maintenance configuration of your application, invoke the DescribeApplication operation.
     *
     * For information about application maintenance, see [Kinesis Data Analytics for Apache Flink Maintenance](https://docs.aws.amazon.com/kinesisanalytics/latest/java/maintenance.html).
     *
     * This operation is supported only for Amazon Kinesis Data Analytics for Apache Flink.
     */
    override suspend fun updateApplicationMaintenanceConfiguration(input: UpdateApplicationMaintenanceConfigurationRequest): UpdateApplicationMaintenanceConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateApplicationMaintenanceConfigurationRequest, UpdateApplicationMaintenanceConfigurationResponse> {
            serializer = UpdateApplicationMaintenanceConfigurationOperationSerializer()
            deserializer = UpdateApplicationMaintenanceConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateApplicationMaintenanceConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("KinesisAnalytics_20180523", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisanalytics"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "kinesisanalytics")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
