// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2.transform

import aws.sdk.kotlin.services.kinesisanalyticsv2.model.DiscoverInputSchemaRequest
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputProcessingConfiguration
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputStartingPositionConfiguration
import aws.sdk.kotlin.services.kinesisanalyticsv2.model.S3Configuration
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DiscoverInputSchemaOperationSerializer: HttpSerialize<DiscoverInputSchemaRequest> {
    override suspend fun serialize(context: ExecutionContext, input: DiscoverInputSchemaRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeDiscoverInputSchemaOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeDiscoverInputSchemaOperationBody(context: ExecutionContext, input: DiscoverInputSchemaRequest): ByteArray {
    val serializer = JsonSerializer()
    val INPUTPROCESSINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("InputProcessingConfiguration"))
    val INPUTSTARTINGPOSITIONCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("InputStartingPositionConfiguration"))
    val RESOURCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceARN"))
    val S3CONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("S3Configuration"))
    val SERVICEEXECUTIONROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ServiceExecutionRole"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INPUTPROCESSINGCONFIGURATION_DESCRIPTOR)
        field(INPUTSTARTINGPOSITIONCONFIGURATION_DESCRIPTOR)
        field(RESOURCEARN_DESCRIPTOR)
        field(S3CONFIGURATION_DESCRIPTOR)
        field(SERVICEEXECUTIONROLE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.inputProcessingConfiguration?.let { field(INPUTPROCESSINGCONFIGURATION_DESCRIPTOR, it, ::serializeInputProcessingConfigurationDocument) }
        input.inputStartingPositionConfiguration?.let { field(INPUTSTARTINGPOSITIONCONFIGURATION_DESCRIPTOR, it, ::serializeInputStartingPositionConfigurationDocument) }
        input.resourceArn?.let { field(RESOURCEARN_DESCRIPTOR, it) }
        input.s3Configuration?.let { field(S3CONFIGURATION_DESCRIPTOR, it, ::serializeS3ConfigurationDocument) }
        input.serviceExecutionRole?.let { field(SERVICEEXECUTIONROLE_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
