// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2.model



/**
 * For a SQL-based Kinesis Data Analytics application, describes updates to the output configuration identified by the `OutputId`.
 */
public class OutputUpdate private constructor(builder: Builder) {
    /**
     * Describes the data format when records are written to the destination.
     */
    public val destinationSchemaUpdate: aws.sdk.kotlin.services.kinesisanalyticsv2.model.DestinationSchema? = builder.destinationSchemaUpdate
    /**
     * Describes a Kinesis Data Firehose delivery stream as the destination for the output.
     */
    public val kinesisFirehoseOutputUpdate: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisFirehoseOutputUpdate? = builder.kinesisFirehoseOutputUpdate
    /**
     * Describes a Kinesis data stream as the destination for the output.
     */
    public val kinesisStreamsOutputUpdate: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisStreamsOutputUpdate? = builder.kinesisStreamsOutputUpdate
    /**
     * Describes an Amazon Lambda function as the destination for the output.
     */
    public val lambdaOutputUpdate: aws.sdk.kotlin.services.kinesisanalyticsv2.model.LambdaOutputUpdate? = builder.lambdaOutputUpdate
    /**
     * If you want to specify a different in-application stream for this output configuration, use this field to specify the new in-application stream name.
     */
    public val nameUpdate: kotlin.String? = builder.nameUpdate
    /**
     * Identifies the specific output configuration that you want to update.
     */
    public val outputId: kotlin.String? = builder.outputId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalyticsv2.model.OutputUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OutputUpdate(")
        append("destinationSchemaUpdate=$destinationSchemaUpdate,")
        append("kinesisFirehoseOutputUpdate=$kinesisFirehoseOutputUpdate,")
        append("kinesisStreamsOutputUpdate=$kinesisStreamsOutputUpdate,")
        append("lambdaOutputUpdate=$lambdaOutputUpdate,")
        append("nameUpdate=$nameUpdate,")
        append("outputId=$outputId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationSchemaUpdate?.hashCode() ?: 0
        result = 31 * result + (kinesisFirehoseOutputUpdate?.hashCode() ?: 0)
        result = 31 * result + (kinesisStreamsOutputUpdate?.hashCode() ?: 0)
        result = 31 * result + (lambdaOutputUpdate?.hashCode() ?: 0)
        result = 31 * result + (nameUpdate?.hashCode() ?: 0)
        result = 31 * result + (outputId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OutputUpdate

        if (destinationSchemaUpdate != other.destinationSchemaUpdate) return false
        if (kinesisFirehoseOutputUpdate != other.kinesisFirehoseOutputUpdate) return false
        if (kinesisStreamsOutputUpdate != other.kinesisStreamsOutputUpdate) return false
        if (lambdaOutputUpdate != other.lambdaOutputUpdate) return false
        if (nameUpdate != other.nameUpdate) return false
        if (outputId != other.outputId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalyticsv2.model.OutputUpdate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Describes the data format when records are written to the destination.
         */
        public var destinationSchemaUpdate: aws.sdk.kotlin.services.kinesisanalyticsv2.model.DestinationSchema? = null
        /**
         * Describes a Kinesis Data Firehose delivery stream as the destination for the output.
         */
        public var kinesisFirehoseOutputUpdate: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisFirehoseOutputUpdate? = null
        /**
         * Describes a Kinesis data stream as the destination for the output.
         */
        public var kinesisStreamsOutputUpdate: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisStreamsOutputUpdate? = null
        /**
         * Describes an Amazon Lambda function as the destination for the output.
         */
        public var lambdaOutputUpdate: aws.sdk.kotlin.services.kinesisanalyticsv2.model.LambdaOutputUpdate? = null
        /**
         * If you want to specify a different in-application stream for this output configuration, use this field to specify the new in-application stream name.
         */
        public var nameUpdate: kotlin.String? = null
        /**
         * Identifies the specific output configuration that you want to update.
         */
        public var outputId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalyticsv2.model.OutputUpdate) : this() {
            this.destinationSchemaUpdate = x.destinationSchemaUpdate
            this.kinesisFirehoseOutputUpdate = x.kinesisFirehoseOutputUpdate
            this.kinesisStreamsOutputUpdate = x.kinesisStreamsOutputUpdate
            this.lambdaOutputUpdate = x.lambdaOutputUpdate
            this.nameUpdate = x.nameUpdate
            this.outputId = x.outputId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalyticsv2.model.OutputUpdate = OutputUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.DestinationSchema] inside the given [block]
         */
        public fun destinationSchemaUpdate(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.DestinationSchema.Builder.() -> kotlin.Unit) {
            this.destinationSchemaUpdate = aws.sdk.kotlin.services.kinesisanalyticsv2.model.DestinationSchema.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisFirehoseOutputUpdate] inside the given [block]
         */
        public fun kinesisFirehoseOutputUpdate(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisFirehoseOutputUpdate.Builder.() -> kotlin.Unit) {
            this.kinesisFirehoseOutputUpdate = aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisFirehoseOutputUpdate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisStreamsOutputUpdate] inside the given [block]
         */
        public fun kinesisStreamsOutputUpdate(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisStreamsOutputUpdate.Builder.() -> kotlin.Unit) {
            this.kinesisStreamsOutputUpdate = aws.sdk.kotlin.services.kinesisanalyticsv2.model.KinesisStreamsOutputUpdate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.LambdaOutputUpdate] inside the given [block]
         */
        public fun lambdaOutputUpdate(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.LambdaOutputUpdate.Builder.() -> kotlin.Unit) {
            this.lambdaOutputUpdate = aws.sdk.kotlin.services.kinesisanalyticsv2.model.LambdaOutputUpdate.invoke(block)
        }
    }
}
