// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2.model



/**
 * When you update an SQL-based Kinesis Data Analytics application's output configuration using the UpdateApplication operation, provides information about an Amazon Lambda function that is configured as the destination.
 */
public class LambdaOutputUpdate private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the destination Amazon Lambda function.
     *
     * To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see [Example ARNs: Amazon Lambda](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
     */
    public val resourceArnUpdate: kotlin.String? = builder.resourceArnUpdate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalyticsv2.model.LambdaOutputUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaOutputUpdate(")
        append("resourceArnUpdate=$resourceArnUpdate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceArnUpdate?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LambdaOutputUpdate

        if (resourceArnUpdate != other.resourceArnUpdate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalyticsv2.model.LambdaOutputUpdate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the destination Amazon Lambda function.
         *
         * To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see [Example ARNs: Amazon Lambda](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
         */
        public var resourceArnUpdate: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalyticsv2.model.LambdaOutputUpdate) : this() {
            this.resourceArnUpdate = x.resourceArnUpdate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalyticsv2.model.LambdaOutputUpdate = LambdaOutputUpdate(this)
    }
}
