// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2.model



/**
 * For a SQL-based Kinesis Data Analytics application, an object that contains the Amazon Resource Name (ARN) of the Amazon Lambda function that is used to preprocess records in the stream.
 */
public class InputLambdaProcessorDescription private constructor(builder: Builder) {
    /**
     * The ARN of the Amazon Lambda function that is used to preprocess the records in the stream.
     *
     * To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see [Example ARNs: Amazon Lambda](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The ARN of the IAM role that is used to access the Amazon Lambda function.
     *
     * Provided for backward compatibility. Applications that are created with the current API version have an application-level service execution role rather than a resource-level role.
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputLambdaProcessorDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InputLambdaProcessorDescription(")
        append("resourceArn=$resourceArn,")
        append("roleArn=$roleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceArn?.hashCode() ?: 0
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InputLambdaProcessorDescription

        if (resourceArn != other.resourceArn) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputLambdaProcessorDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the Amazon Lambda function that is used to preprocess the records in the stream.
         *
         * To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see [Example ARNs: Amazon Lambda](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The ARN of the IAM role that is used to access the Amazon Lambda function.
         *
         * Provided for backward compatibility. Applications that are created with the current API version have an application-level service execution role rather than a resource-level role.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputLambdaProcessorDescription) : this() {
            this.resourceArn = x.resourceArn
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalyticsv2.model.InputLambdaProcessorDescription = InputLambdaProcessorDescription(this)
    }
}
