// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2.model



/**
 * Describes an application's checkpointing configuration. Checkpointing is the process of persisting application state for fault tolerance. For more information, see [ Checkpoints for Fault Tolerance](https://ci.apache.org/projects/flink/flink-docs-release-1.8/concepts/programming-model.html#checkpoints-for-fault-tolerance) in the [Apache Flink Documentation](https://ci.apache.org/projects/flink/flink-docs-release-1.8/).
 */
public class CheckpointConfiguration private constructor(builder: Builder) {
    /**
     * Describes the interval in milliseconds between checkpoint operations.
     *
     * If `CheckpointConfiguration.ConfigurationType` is `DEFAULT`, the application will use a `CheckpointInterval` value of 60000, even if this value is set to another value using this API or in application code.
     */
    public val checkpointInterval: kotlin.Long? = builder.checkpointInterval
    /**
     * Describes whether checkpointing is enabled for a Flink-based Kinesis Data Analytics application.
     *
     * If `CheckpointConfiguration.ConfigurationType` is `DEFAULT`, the application will use a `CheckpointingEnabled` value of `true`, even if this value is set to another value using this API or in application code.
     */
    public val checkpointingEnabled: kotlin.Boolean? = builder.checkpointingEnabled
    /**
     * Describes whether the application uses Kinesis Data Analytics' default checkpointing behavior. You must set this property to `CUSTOM` in order to set the `CheckpointingEnabled`, `CheckpointInterval`, or `MinPauseBetweenCheckpoints` parameters.
     *
     * If this value is set to `DEFAULT`, the application will use the following values, even if they are set to other values using APIs or application code:
     * + **CheckpointingEnabled:** true
     * + **CheckpointInterval:** 60000
     * + **MinPauseBetweenCheckpoints:** 5000
     */
    public val configurationType: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ConfigurationType? = builder.configurationType
    /**
     * Describes the minimum time in milliseconds after a checkpoint operation completes that a new checkpoint operation can start. If a checkpoint operation takes longer than the `CheckpointInterval`, the application otherwise performs continual checkpoint operations. For more information, see [ Tuning Checkpointing](https://ci.apache.org/projects/flink/flink-docs-release-1.8/ops/state/large_state_tuning.html#tuning-checkpointing) in the [Apache Flink Documentation](https://ci.apache.org/projects/flink/flink-docs-release-1.8/).
     *
     * If `CheckpointConfiguration.ConfigurationType` is `DEFAULT`, the application will use a `MinPauseBetweenCheckpoints` value of 5000, even if this value is set using this API or in application code.
     */
    public val minPauseBetweenCheckpoints: kotlin.Long? = builder.minPauseBetweenCheckpoints

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalyticsv2.model.CheckpointConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CheckpointConfiguration(")
        append("checkpointInterval=$checkpointInterval,")
        append("checkpointingEnabled=$checkpointingEnabled,")
        append("configurationType=$configurationType,")
        append("minPauseBetweenCheckpoints=$minPauseBetweenCheckpoints)")
    }

    override fun hashCode(): kotlin.Int {
        var result = checkpointInterval?.hashCode() ?: 0
        result = 31 * result + (checkpointingEnabled?.hashCode() ?: 0)
        result = 31 * result + (configurationType?.hashCode() ?: 0)
        result = 31 * result + (minPauseBetweenCheckpoints?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CheckpointConfiguration

        if (checkpointInterval != other.checkpointInterval) return false
        if (checkpointingEnabled != other.checkpointingEnabled) return false
        if (configurationType != other.configurationType) return false
        if (minPauseBetweenCheckpoints != other.minPauseBetweenCheckpoints) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalyticsv2.model.CheckpointConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Describes the interval in milliseconds between checkpoint operations.
         *
         * If `CheckpointConfiguration.ConfigurationType` is `DEFAULT`, the application will use a `CheckpointInterval` value of 60000, even if this value is set to another value using this API or in application code.
         */
        public var checkpointInterval: kotlin.Long? = null
        /**
         * Describes whether checkpointing is enabled for a Flink-based Kinesis Data Analytics application.
         *
         * If `CheckpointConfiguration.ConfigurationType` is `DEFAULT`, the application will use a `CheckpointingEnabled` value of `true`, even if this value is set to another value using this API or in application code.
         */
        public var checkpointingEnabled: kotlin.Boolean? = null
        /**
         * Describes whether the application uses Kinesis Data Analytics' default checkpointing behavior. You must set this property to `CUSTOM` in order to set the `CheckpointingEnabled`, `CheckpointInterval`, or `MinPauseBetweenCheckpoints` parameters.
         *
         * If this value is set to `DEFAULT`, the application will use the following values, even if they are set to other values using APIs or application code:
         * + **CheckpointingEnabled:** true
         * + **CheckpointInterval:** 60000
         * + **MinPauseBetweenCheckpoints:** 5000
         */
        public var configurationType: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ConfigurationType? = null
        /**
         * Describes the minimum time in milliseconds after a checkpoint operation completes that a new checkpoint operation can start. If a checkpoint operation takes longer than the `CheckpointInterval`, the application otherwise performs continual checkpoint operations. For more information, see [ Tuning Checkpointing](https://ci.apache.org/projects/flink/flink-docs-release-1.8/ops/state/large_state_tuning.html#tuning-checkpointing) in the [Apache Flink Documentation](https://ci.apache.org/projects/flink/flink-docs-release-1.8/).
         *
         * If `CheckpointConfiguration.ConfigurationType` is `DEFAULT`, the application will use a `MinPauseBetweenCheckpoints` value of 5000, even if this value is set using this API or in application code.
         */
        public var minPauseBetweenCheckpoints: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalyticsv2.model.CheckpointConfiguration) : this() {
            this.checkpointInterval = x.checkpointInterval
            this.checkpointingEnabled = x.checkpointingEnabled
            this.configurationType = x.configurationType
            this.minPauseBetweenCheckpoints = x.minPauseBetweenCheckpoints
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalyticsv2.model.CheckpointConfiguration = CheckpointConfiguration(this)
    }
}
