// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalyticsv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the application, including the application Amazon Resource Name (ARN), status, latest version, and input and output configurations.
 */
public class ApplicationDetail private constructor(builder: Builder) {
    /**
     * The ARN of the application.
     */
    public val applicationArn: kotlin.String? = builder.applicationArn
    /**
     * Describes details about the application code and starting parameters for a Kinesis Data Analytics application.
     */
    public val applicationConfigurationDescription: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ApplicationConfigurationDescription? = builder.applicationConfigurationDescription
    /**
     * The description of the application.
     */
    public val applicationDescription: kotlin.String? = builder.applicationDescription
    /**
     * The details of the maintenance configuration for the application.
     */
    public val applicationMaintenanceConfigurationDescription: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription? = builder.applicationMaintenanceConfigurationDescription
    /**
     * To create a Kinesis Data Analytics Studio notebook, you must set the mode to `INTERACTIVE`. However, for a Kinesis Data Analytics for Apache Flink application, the mode is optional.
     */
    public val applicationMode: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ApplicationMode? = builder.applicationMode
    /**
     * The name of the application.
     */
    public val applicationName: kotlin.String? = builder.applicationName
    /**
     * The status of the application.
     */
    public val applicationStatus: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ApplicationStatus? = builder.applicationStatus
    /**
     * Provides the current application version. Kinesis Data Analytics updates the `ApplicationVersionId` each time you update the application.
     */
    public val applicationVersionId: kotlin.Long? = builder.applicationVersionId
    /**
     * If you reverted the application using RollbackApplication, the application version when `RollbackApplication` was called.
     */
    public val applicationVersionRolledBackFrom: kotlin.Long? = builder.applicationVersionRolledBackFrom
    /**
     * The version to which you want to roll back the application.
     */
    public val applicationVersionRolledBackTo: kotlin.Long? = builder.applicationVersionRolledBackTo
    /**
     * The previous application version before the latest application update. RollbackApplication reverts the application to this version.
     */
    public val applicationVersionUpdatedFrom: kotlin.Long? = builder.applicationVersionUpdatedFrom
    /**
     * Describes the application Amazon CloudWatch logging options.
     */
    public val cloudWatchLoggingOptionDescriptions: List<CloudWatchLoggingOptionDescription>? = builder.cloudWatchLoggingOptionDescriptions
    /**
     * A value you use to implement strong concurrency for application updates.
     */
    public val conditionalToken: kotlin.String? = builder.conditionalToken
    /**
     * The current timestamp when the application was created.
     */
    public val createTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createTimestamp
    /**
     * The current timestamp when the application was last updated.
     */
    public val lastUpdateTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdateTimestamp
    /**
     * The runtime environment for the application (`SQL-1_0`, `FLINK-1_6`, `FLINK-1_8`, or `FLINK-1_11`).
     */
    public val runtimeEnvironment: aws.sdk.kotlin.services.kinesisanalyticsv2.model.RuntimeEnvironment? = builder.runtimeEnvironment
    /**
     * Specifies the IAM role that the application uses to access external resources.
     */
    public val serviceExecutionRole: kotlin.String? = builder.serviceExecutionRole

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalyticsv2.model.ApplicationDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationDetail(")
        append("applicationArn=$applicationArn,")
        append("applicationConfigurationDescription=$applicationConfigurationDescription,")
        append("applicationDescription=$applicationDescription,")
        append("applicationMaintenanceConfigurationDescription=$applicationMaintenanceConfigurationDescription,")
        append("applicationMode=$applicationMode,")
        append("applicationName=$applicationName,")
        append("applicationStatus=$applicationStatus,")
        append("applicationVersionId=$applicationVersionId,")
        append("applicationVersionRolledBackFrom=$applicationVersionRolledBackFrom,")
        append("applicationVersionRolledBackTo=$applicationVersionRolledBackTo,")
        append("applicationVersionUpdatedFrom=$applicationVersionUpdatedFrom,")
        append("cloudWatchLoggingOptionDescriptions=$cloudWatchLoggingOptionDescriptions,")
        append("conditionalToken=$conditionalToken,")
        append("createTimestamp=$createTimestamp,")
        append("lastUpdateTimestamp=$lastUpdateTimestamp,")
        append("runtimeEnvironment=$runtimeEnvironment,")
        append("serviceExecutionRole=$serviceExecutionRole)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationArn?.hashCode() ?: 0
        result = 31 * result + (applicationConfigurationDescription?.hashCode() ?: 0)
        result = 31 * result + (applicationDescription?.hashCode() ?: 0)
        result = 31 * result + (applicationMaintenanceConfigurationDescription?.hashCode() ?: 0)
        result = 31 * result + (applicationMode?.hashCode() ?: 0)
        result = 31 * result + (applicationName?.hashCode() ?: 0)
        result = 31 * result + (applicationStatus?.hashCode() ?: 0)
        result = 31 * result + (applicationVersionId?.hashCode() ?: 0)
        result = 31 * result + (applicationVersionRolledBackFrom?.hashCode() ?: 0)
        result = 31 * result + (applicationVersionRolledBackTo?.hashCode() ?: 0)
        result = 31 * result + (applicationVersionUpdatedFrom?.hashCode() ?: 0)
        result = 31 * result + (cloudWatchLoggingOptionDescriptions?.hashCode() ?: 0)
        result = 31 * result + (conditionalToken?.hashCode() ?: 0)
        result = 31 * result + (createTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateTimestamp?.hashCode() ?: 0)
        result = 31 * result + (runtimeEnvironment?.hashCode() ?: 0)
        result = 31 * result + (serviceExecutionRole?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApplicationDetail

        if (applicationArn != other.applicationArn) return false
        if (applicationConfigurationDescription != other.applicationConfigurationDescription) return false
        if (applicationDescription != other.applicationDescription) return false
        if (applicationMaintenanceConfigurationDescription != other.applicationMaintenanceConfigurationDescription) return false
        if (applicationMode != other.applicationMode) return false
        if (applicationName != other.applicationName) return false
        if (applicationStatus != other.applicationStatus) return false
        if (applicationVersionId != other.applicationVersionId) return false
        if (applicationVersionRolledBackFrom != other.applicationVersionRolledBackFrom) return false
        if (applicationVersionRolledBackTo != other.applicationVersionRolledBackTo) return false
        if (applicationVersionUpdatedFrom != other.applicationVersionUpdatedFrom) return false
        if (cloudWatchLoggingOptionDescriptions != other.cloudWatchLoggingOptionDescriptions) return false
        if (conditionalToken != other.conditionalToken) return false
        if (createTimestamp != other.createTimestamp) return false
        if (lastUpdateTimestamp != other.lastUpdateTimestamp) return false
        if (runtimeEnvironment != other.runtimeEnvironment) return false
        if (serviceExecutionRole != other.serviceExecutionRole) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalyticsv2.model.ApplicationDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the application.
         */
        public var applicationArn: kotlin.String? = null
        /**
         * Describes details about the application code and starting parameters for a Kinesis Data Analytics application.
         */
        public var applicationConfigurationDescription: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ApplicationConfigurationDescription? = null
        /**
         * The description of the application.
         */
        public var applicationDescription: kotlin.String? = null
        /**
         * The details of the maintenance configuration for the application.
         */
        public var applicationMaintenanceConfigurationDescription: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription? = null
        /**
         * To create a Kinesis Data Analytics Studio notebook, you must set the mode to `INTERACTIVE`. However, for a Kinesis Data Analytics for Apache Flink application, the mode is optional.
         */
        public var applicationMode: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ApplicationMode? = null
        /**
         * The name of the application.
         */
        public var applicationName: kotlin.String? = null
        /**
         * The status of the application.
         */
        public var applicationStatus: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ApplicationStatus? = null
        /**
         * Provides the current application version. Kinesis Data Analytics updates the `ApplicationVersionId` each time you update the application.
         */
        public var applicationVersionId: kotlin.Long? = null
        /**
         * If you reverted the application using RollbackApplication, the application version when `RollbackApplication` was called.
         */
        public var applicationVersionRolledBackFrom: kotlin.Long? = null
        /**
         * The version to which you want to roll back the application.
         */
        public var applicationVersionRolledBackTo: kotlin.Long? = null
        /**
         * The previous application version before the latest application update. RollbackApplication reverts the application to this version.
         */
        public var applicationVersionUpdatedFrom: kotlin.Long? = null
        /**
         * Describes the application Amazon CloudWatch logging options.
         */
        public var cloudWatchLoggingOptionDescriptions: List<CloudWatchLoggingOptionDescription>? = null
        /**
         * A value you use to implement strong concurrency for application updates.
         */
        public var conditionalToken: kotlin.String? = null
        /**
         * The current timestamp when the application was created.
         */
        public var createTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current timestamp when the application was last updated.
         */
        public var lastUpdateTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The runtime environment for the application (`SQL-1_0`, `FLINK-1_6`, `FLINK-1_8`, or `FLINK-1_11`).
         */
        public var runtimeEnvironment: aws.sdk.kotlin.services.kinesisanalyticsv2.model.RuntimeEnvironment? = null
        /**
         * Specifies the IAM role that the application uses to access external resources.
         */
        public var serviceExecutionRole: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ApplicationDetail) : this() {
            this.applicationArn = x.applicationArn
            this.applicationConfigurationDescription = x.applicationConfigurationDescription
            this.applicationDescription = x.applicationDescription
            this.applicationMaintenanceConfigurationDescription = x.applicationMaintenanceConfigurationDescription
            this.applicationMode = x.applicationMode
            this.applicationName = x.applicationName
            this.applicationStatus = x.applicationStatus
            this.applicationVersionId = x.applicationVersionId
            this.applicationVersionRolledBackFrom = x.applicationVersionRolledBackFrom
            this.applicationVersionRolledBackTo = x.applicationVersionRolledBackTo
            this.applicationVersionUpdatedFrom = x.applicationVersionUpdatedFrom
            this.cloudWatchLoggingOptionDescriptions = x.cloudWatchLoggingOptionDescriptions
            this.conditionalToken = x.conditionalToken
            this.createTimestamp = x.createTimestamp
            this.lastUpdateTimestamp = x.lastUpdateTimestamp
            this.runtimeEnvironment = x.runtimeEnvironment
            this.serviceExecutionRole = x.serviceExecutionRole
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalyticsv2.model.ApplicationDetail = ApplicationDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.ApplicationConfigurationDescription] inside the given [block]
         */
        public fun applicationConfigurationDescription(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ApplicationConfigurationDescription.Builder.() -> kotlin.Unit) {
            this.applicationConfigurationDescription = aws.sdk.kotlin.services.kinesisanalyticsv2.model.ApplicationConfigurationDescription.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription] inside the given [block]
         */
        public fun applicationMaintenanceConfigurationDescription(block: aws.sdk.kotlin.services.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription.Builder.() -> kotlin.Unit) {
            this.applicationMaintenanceConfigurationDescription = aws.sdk.kotlin.services.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription.invoke(block)
        }
    }
}
