// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalytics.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the mapping of each data element in the streaming source to the corresponding column in the in-application stream.
 *
 * Also used to describe the format of the reference data source.
 */
public class RecordColumn private constructor(builder: Builder) {
    /**
     * Reference to the data element in the streaming input or the reference data source. This element is required if the [RecordFormatType](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_RecordFormat.html#analytics-Type-RecordFormat-RecordFormatTypel) is `JSON`.
     */
    public val mapping: kotlin.String? = builder.mapping
    /**
     * Name of the column created in the in-application input stream or reference table.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Type of column created in the in-application input stream or reference table.
     */
    public val sqlType: kotlin.String = requireNotNull(builder.sqlType) { "A non-null value must be provided for sqlType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalytics.model.RecordColumn = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecordColumn(")
        append("mapping=$mapping,")
        append("name=$name,")
        append("sqlType=$sqlType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = mapping?.hashCode() ?: 0
        result = 31 * result + (name.hashCode())
        result = 31 * result + (sqlType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecordColumn

        if (mapping != other.mapping) return false
        if (name != other.name) return false
        if (sqlType != other.sqlType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalytics.model.RecordColumn = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Reference to the data element in the streaming input or the reference data source. This element is required if the [RecordFormatType](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_RecordFormat.html#analytics-Type-RecordFormat-RecordFormatTypel) is `JSON`.
         */
        public var mapping: kotlin.String? = null
        /**
         * Name of the column created in the in-application input stream or reference table.
         */
        public var name: kotlin.String? = null
        /**
         * Type of column created in the in-application input stream or reference table.
         */
        public var sqlType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalytics.model.RecordColumn) : this() {
            this.mapping = x.mapping
            this.name = x.name
            this.sqlType = x.sqlType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalytics.model.RecordColumn = RecordColumn(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (sqlType == null) sqlType = ""
            return this
        }
    }
}
