// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalytics.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the Amazon Kinesis Firehose delivery stream that is configured as the streaming source in the application input configuration.
 */
public class KinesisFirehoseInputDescription private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the Amazon Kinesis Firehose delivery stream.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * ARN of the IAM role that Amazon Kinesis Analytics assumes to access the stream.
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalytics.model.KinesisFirehoseInputDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KinesisFirehoseInputDescription(")
        append("resourceArn=$resourceArn,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceArn?.hashCode() ?: 0
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KinesisFirehoseInputDescription

        if (resourceArn != other.resourceArn) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalytics.model.KinesisFirehoseInputDescription = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the Amazon Kinesis Firehose delivery stream.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * ARN of the IAM role that Amazon Kinesis Analytics assumes to access the stream.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalytics.model.KinesisFirehoseInputDescription) : this() {
            this.resourceArn = x.resourceArn
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalytics.model.KinesisFirehoseInputDescription = KinesisFirehoseInputDescription(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
