// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalytics.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the application input configuration. For more information, see [Configuring Application Input](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
 */
public class InputDescription private constructor(builder: Builder) {
    /**
     * Returns the in-application stream names that are mapped to the stream source.
     */
    public val inAppStreamNames: List<String>? = builder.inAppStreamNames
    /**
     * Input ID associated with the application input. This is the ID that Amazon Kinesis Analytics assigns to each input configuration you add to your application.
     */
    public val inputId: kotlin.String? = builder.inputId
    /**
     * Describes the configured parallelism (number of in-application streams mapped to the streaming source).
     */
    public val inputParallelism: aws.sdk.kotlin.services.kinesisanalytics.model.InputParallelism? = builder.inputParallelism
    /**
     * The description of the preprocessor that executes on records in this input before the application's code is run.
     */
    public val inputProcessingConfigurationDescription: aws.sdk.kotlin.services.kinesisanalytics.model.InputProcessingConfigurationDescription? = builder.inputProcessingConfigurationDescription
    /**
     * Describes the format of the data in the streaming source, and how each data element maps to corresponding columns in the in-application stream that is being created.
     */
    public val inputSchema: aws.sdk.kotlin.services.kinesisanalytics.model.SourceSchema? = builder.inputSchema
    /**
     * Point at which the application is configured to read from the input stream.
     */
    public val inputStartingPositionConfiguration: aws.sdk.kotlin.services.kinesisanalytics.model.InputStartingPositionConfiguration? = builder.inputStartingPositionConfiguration
    /**
     * If an Amazon Kinesis Firehose delivery stream is configured as a streaming source, provides the delivery stream's ARN and an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
     */
    public val kinesisFirehoseInputDescription: aws.sdk.kotlin.services.kinesisanalytics.model.KinesisFirehoseInputDescription? = builder.kinesisFirehoseInputDescription
    /**
     * If an Amazon Kinesis stream is configured as streaming source, provides Amazon Kinesis stream's Amazon Resource Name (ARN) and an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
     */
    public val kinesisStreamsInputDescription: aws.sdk.kotlin.services.kinesisanalytics.model.KinesisStreamsInputDescription? = builder.kinesisStreamsInputDescription
    /**
     * In-application name prefix.
     */
    public val namePrefix: kotlin.String? = builder.namePrefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalytics.model.InputDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InputDescription(")
        append("inAppStreamNames=$inAppStreamNames,")
        append("inputId=$inputId,")
        append("inputParallelism=$inputParallelism,")
        append("inputProcessingConfigurationDescription=$inputProcessingConfigurationDescription,")
        append("inputSchema=$inputSchema,")
        append("inputStartingPositionConfiguration=$inputStartingPositionConfiguration,")
        append("kinesisFirehoseInputDescription=$kinesisFirehoseInputDescription,")
        append("kinesisStreamsInputDescription=$kinesisStreamsInputDescription,")
        append("namePrefix=$namePrefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = inAppStreamNames?.hashCode() ?: 0
        result = 31 * result + (inputId?.hashCode() ?: 0)
        result = 31 * result + (inputParallelism?.hashCode() ?: 0)
        result = 31 * result + (inputProcessingConfigurationDescription?.hashCode() ?: 0)
        result = 31 * result + (inputSchema?.hashCode() ?: 0)
        result = 31 * result + (inputStartingPositionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (kinesisFirehoseInputDescription?.hashCode() ?: 0)
        result = 31 * result + (kinesisStreamsInputDescription?.hashCode() ?: 0)
        result = 31 * result + (namePrefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InputDescription

        if (inAppStreamNames != other.inAppStreamNames) return false
        if (inputId != other.inputId) return false
        if (inputParallelism != other.inputParallelism) return false
        if (inputProcessingConfigurationDescription != other.inputProcessingConfigurationDescription) return false
        if (inputSchema != other.inputSchema) return false
        if (inputStartingPositionConfiguration != other.inputStartingPositionConfiguration) return false
        if (kinesisFirehoseInputDescription != other.kinesisFirehoseInputDescription) return false
        if (kinesisStreamsInputDescription != other.kinesisStreamsInputDescription) return false
        if (namePrefix != other.namePrefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalytics.model.InputDescription = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Returns the in-application stream names that are mapped to the stream source.
         */
        public var inAppStreamNames: List<String>? = null
        /**
         * Input ID associated with the application input. This is the ID that Amazon Kinesis Analytics assigns to each input configuration you add to your application.
         */
        public var inputId: kotlin.String? = null
        /**
         * Describes the configured parallelism (number of in-application streams mapped to the streaming source).
         */
        public var inputParallelism: aws.sdk.kotlin.services.kinesisanalytics.model.InputParallelism? = null
        /**
         * The description of the preprocessor that executes on records in this input before the application's code is run.
         */
        public var inputProcessingConfigurationDescription: aws.sdk.kotlin.services.kinesisanalytics.model.InputProcessingConfigurationDescription? = null
        /**
         * Describes the format of the data in the streaming source, and how each data element maps to corresponding columns in the in-application stream that is being created.
         */
        public var inputSchema: aws.sdk.kotlin.services.kinesisanalytics.model.SourceSchema? = null
        /**
         * Point at which the application is configured to read from the input stream.
         */
        public var inputStartingPositionConfiguration: aws.sdk.kotlin.services.kinesisanalytics.model.InputStartingPositionConfiguration? = null
        /**
         * If an Amazon Kinesis Firehose delivery stream is configured as a streaming source, provides the delivery stream's ARN and an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
         */
        public var kinesisFirehoseInputDescription: aws.sdk.kotlin.services.kinesisanalytics.model.KinesisFirehoseInputDescription? = null
        /**
         * If an Amazon Kinesis stream is configured as streaming source, provides Amazon Kinesis stream's Amazon Resource Name (ARN) and an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
         */
        public var kinesisStreamsInputDescription: aws.sdk.kotlin.services.kinesisanalytics.model.KinesisStreamsInputDescription? = null
        /**
         * In-application name prefix.
         */
        public var namePrefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalytics.model.InputDescription) : this() {
            this.inAppStreamNames = x.inAppStreamNames
            this.inputId = x.inputId
            this.inputParallelism = x.inputParallelism
            this.inputProcessingConfigurationDescription = x.inputProcessingConfigurationDescription
            this.inputSchema = x.inputSchema
            this.inputStartingPositionConfiguration = x.inputStartingPositionConfiguration
            this.kinesisFirehoseInputDescription = x.kinesisFirehoseInputDescription
            this.kinesisStreamsInputDescription = x.kinesisStreamsInputDescription
            this.namePrefix = x.namePrefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalytics.model.InputDescription = InputDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalytics.model.InputParallelism] inside the given [block]
         */
        public fun inputParallelism(block: aws.sdk.kotlin.services.kinesisanalytics.model.InputParallelism.Builder.() -> kotlin.Unit) {
            this.inputParallelism = aws.sdk.kotlin.services.kinesisanalytics.model.InputParallelism.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalytics.model.InputProcessingConfigurationDescription] inside the given [block]
         */
        public fun inputProcessingConfigurationDescription(block: aws.sdk.kotlin.services.kinesisanalytics.model.InputProcessingConfigurationDescription.Builder.() -> kotlin.Unit) {
            this.inputProcessingConfigurationDescription = aws.sdk.kotlin.services.kinesisanalytics.model.InputProcessingConfigurationDescription.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalytics.model.SourceSchema] inside the given [block]
         */
        public fun inputSchema(block: aws.sdk.kotlin.services.kinesisanalytics.model.SourceSchema.Builder.() -> kotlin.Unit) {
            this.inputSchema = aws.sdk.kotlin.services.kinesisanalytics.model.SourceSchema.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalytics.model.InputStartingPositionConfiguration] inside the given [block]
         */
        public fun inputStartingPositionConfiguration(block: aws.sdk.kotlin.services.kinesisanalytics.model.InputStartingPositionConfiguration.Builder.() -> kotlin.Unit) {
            this.inputStartingPositionConfiguration = aws.sdk.kotlin.services.kinesisanalytics.model.InputStartingPositionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalytics.model.KinesisFirehoseInputDescription] inside the given [block]
         */
        public fun kinesisFirehoseInputDescription(block: aws.sdk.kotlin.services.kinesisanalytics.model.KinesisFirehoseInputDescription.Builder.() -> kotlin.Unit) {
            this.kinesisFirehoseInputDescription = aws.sdk.kotlin.services.kinesisanalytics.model.KinesisFirehoseInputDescription.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalytics.model.KinesisStreamsInputDescription] inside the given [block]
         */
        public fun kinesisStreamsInputDescription(block: aws.sdk.kotlin.services.kinesisanalytics.model.KinesisStreamsInputDescription.Builder.() -> kotlin.Unit) {
            this.kinesisStreamsInputDescription = aws.sdk.kotlin.services.kinesisanalytics.model.KinesisStreamsInputDescription.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
