// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalytics.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DiscoverInputSchemaRequest private constructor(builder: Builder) {
    /**
     * The [InputProcessingConfiguration](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html) to use to preprocess the records before discovering the schema of the records.
     */
    public val inputProcessingConfiguration: aws.sdk.kotlin.services.kinesisanalytics.model.InputProcessingConfiguration? = builder.inputProcessingConfiguration
    /**
     * Point at which you want Amazon Kinesis Analytics to start reading records from the specified streaming source discovery purposes.
     */
    public val inputStartingPositionConfiguration: aws.sdk.kotlin.services.kinesisanalytics.model.InputStartingPositionConfiguration? = builder.inputStartingPositionConfiguration
    /**
     * Amazon Resource Name (ARN) of the streaming source.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Specify this parameter to discover a schema from data in an Amazon S3 object.
     */
    public val s3Configuration: aws.sdk.kotlin.services.kinesisanalytics.model.S3Configuration? = builder.s3Configuration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalytics.model.DiscoverInputSchemaRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DiscoverInputSchemaRequest(")
        append("inputProcessingConfiguration=$inputProcessingConfiguration,")
        append("inputStartingPositionConfiguration=$inputStartingPositionConfiguration,")
        append("resourceArn=$resourceArn,")
        append("roleArn=$roleArn,")
        append("s3Configuration=$s3Configuration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = inputProcessingConfiguration?.hashCode() ?: 0
        result = 31 * result + (inputStartingPositionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (s3Configuration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DiscoverInputSchemaRequest

        if (inputProcessingConfiguration != other.inputProcessingConfiguration) return false
        if (inputStartingPositionConfiguration != other.inputStartingPositionConfiguration) return false
        if (resourceArn != other.resourceArn) return false
        if (roleArn != other.roleArn) return false
        if (s3Configuration != other.s3Configuration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalytics.model.DiscoverInputSchemaRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The [InputProcessingConfiguration](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html) to use to preprocess the records before discovering the schema of the records.
         */
        public var inputProcessingConfiguration: aws.sdk.kotlin.services.kinesisanalytics.model.InputProcessingConfiguration? = null
        /**
         * Point at which you want Amazon Kinesis Analytics to start reading records from the specified streaming source discovery purposes.
         */
        public var inputStartingPositionConfiguration: aws.sdk.kotlin.services.kinesisanalytics.model.InputStartingPositionConfiguration? = null
        /**
         * Amazon Resource Name (ARN) of the streaming source.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Specify this parameter to discover a schema from data in an Amazon S3 object.
         */
        public var s3Configuration: aws.sdk.kotlin.services.kinesisanalytics.model.S3Configuration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalytics.model.DiscoverInputSchemaRequest) : this() {
            this.inputProcessingConfiguration = x.inputProcessingConfiguration
            this.inputStartingPositionConfiguration = x.inputStartingPositionConfiguration
            this.resourceArn = x.resourceArn
            this.roleArn = x.roleArn
            this.s3Configuration = x.s3Configuration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalytics.model.DiscoverInputSchemaRequest = DiscoverInputSchemaRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalytics.model.InputProcessingConfiguration] inside the given [block]
         */
        public fun inputProcessingConfiguration(block: aws.sdk.kotlin.services.kinesisanalytics.model.InputProcessingConfiguration.Builder.() -> kotlin.Unit) {
            this.inputProcessingConfiguration = aws.sdk.kotlin.services.kinesisanalytics.model.InputProcessingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalytics.model.InputStartingPositionConfiguration] inside the given [block]
         */
        public fun inputStartingPositionConfiguration(block: aws.sdk.kotlin.services.kinesisanalytics.model.InputStartingPositionConfiguration.Builder.() -> kotlin.Unit) {
            this.inputStartingPositionConfiguration = aws.sdk.kotlin.services.kinesisanalytics.model.InputStartingPositionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalytics.model.S3Configuration] inside the given [block]
         */
        public fun s3Configuration(block: aws.sdk.kotlin.services.kinesisanalytics.model.S3Configuration.Builder.() -> kotlin.Unit) {
            this.s3Configuration = aws.sdk.kotlin.services.kinesisanalytics.model.S3Configuration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
