// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalytics.serde

import aws.sdk.kotlin.services.kinesisanalytics.model.CloudWatchLoggingOption
import aws.sdk.kotlin.services.kinesisanalytics.model.CreateApplicationRequest
import aws.sdk.kotlin.services.kinesisanalytics.model.Input
import aws.sdk.kotlin.services.kinesisanalytics.model.Output
import aws.sdk.kotlin.services.kinesisanalytics.model.Tag
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateApplicationOperationSerializer: HttpSerializer.NonStreaming<CreateApplicationRequest> {
    override fun serialize(context: ExecutionContext, input: CreateApplicationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeCreateApplicationOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeCreateApplicationOperationBody(context: ExecutionContext, input: CreateApplicationRequest): ByteArray {
    val serializer = JsonSerializer()
    val APPLICATIONCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ApplicationCode"))
    val APPLICATIONDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ApplicationDescription"))
    val APPLICATIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ApplicationName"))
    val CLOUDWATCHLOGGINGOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("CloudWatchLoggingOptions"))
    val INPUTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Inputs"))
    val OUTPUTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Outputs"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLICATIONCODE_DESCRIPTOR)
        field(APPLICATIONDESCRIPTION_DESCRIPTOR)
        field(APPLICATIONNAME_DESCRIPTOR)
        field(CLOUDWATCHLOGGINGOPTIONS_DESCRIPTOR)
        field(INPUTS_DESCRIPTOR)
        field(OUTPUTS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.applicationCode?.let { field(APPLICATIONCODE_DESCRIPTOR, it) }
        input.applicationDescription?.let { field(APPLICATIONDESCRIPTION_DESCRIPTOR, it) }
        input.applicationName?.let { field(APPLICATIONNAME_DESCRIPTOR, it) }
        if (input.cloudWatchLoggingOptions != null) {
            listField(CLOUDWATCHLOGGINGOPTIONS_DESCRIPTOR) {
                for (el0 in input.cloudWatchLoggingOptions) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeCloudWatchLoggingOptionDocument))
                }
            }
        }
        if (input.inputs != null) {
            listField(INPUTS_DESCRIPTOR) {
                for (el0 in input.inputs) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeInputDocument))
                }
            }
        }
        if (input.outputs != null) {
            listField(OUTPUTS_DESCRIPTOR) {
                for (el0 in input.outputs) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeOutputDocument))
                }
            }
        }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
