// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalytics.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the reference data source configured for an application.
 */
public class ReferenceDataSourceDescription private constructor(builder: Builder) {
    /**
     * ID of the reference data source. This is the ID that Amazon Kinesis Analytics assigns when you add the reference data source to your application using the [AddApplicationReferenceDataSource](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationReferenceDataSource.html) operation.
     */
    public val referenceId: kotlin.String = requireNotNull(builder.referenceId) { "A non-null value must be provided for referenceId" }
    /**
     * Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream.
     */
    public val referenceSchema: aws.sdk.kotlin.services.kinesisanalytics.model.SourceSchema? = builder.referenceSchema
    /**
     * Provides the S3 bucket name, the object key name that contains the reference data. It also provides the Amazon Resource Name (ARN) of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object and populate the in-application reference table.
     */
    public val s3ReferenceDataSourceDescription: aws.sdk.kotlin.services.kinesisanalytics.model.S3ReferenceDataSourceDescription? = builder.s3ReferenceDataSourceDescription
    /**
     * The in-application table name created by the specific reference data source configuration.
     */
    public val tableName: kotlin.String = requireNotNull(builder.tableName) { "A non-null value must be provided for tableName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalytics.model.ReferenceDataSourceDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReferenceDataSourceDescription(")
        append("referenceId=$referenceId,")
        append("referenceSchema=$referenceSchema,")
        append("s3ReferenceDataSourceDescription=$s3ReferenceDataSourceDescription,")
        append("tableName=$tableName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = referenceId.hashCode()
        result = 31 * result + (this.referenceSchema?.hashCode() ?: 0)
        result = 31 * result + (this.s3ReferenceDataSourceDescription?.hashCode() ?: 0)
        result = 31 * result + (this.tableName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReferenceDataSourceDescription

        if (referenceId != other.referenceId) return false
        if (referenceSchema != other.referenceSchema) return false
        if (s3ReferenceDataSourceDescription != other.s3ReferenceDataSourceDescription) return false
        if (tableName != other.tableName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalytics.model.ReferenceDataSourceDescription = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * ID of the reference data source. This is the ID that Amazon Kinesis Analytics assigns when you add the reference data source to your application using the [AddApplicationReferenceDataSource](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationReferenceDataSource.html) operation.
         */
        public var referenceId: kotlin.String? = null
        /**
         * Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream.
         */
        public var referenceSchema: aws.sdk.kotlin.services.kinesisanalytics.model.SourceSchema? = null
        /**
         * Provides the S3 bucket name, the object key name that contains the reference data. It also provides the Amazon Resource Name (ARN) of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object and populate the in-application reference table.
         */
        public var s3ReferenceDataSourceDescription: aws.sdk.kotlin.services.kinesisanalytics.model.S3ReferenceDataSourceDescription? = null
        /**
         * The in-application table name created by the specific reference data source configuration.
         */
        public var tableName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalytics.model.ReferenceDataSourceDescription) : this() {
            this.referenceId = x.referenceId
            this.referenceSchema = x.referenceSchema
            this.s3ReferenceDataSourceDescription = x.s3ReferenceDataSourceDescription
            this.tableName = x.tableName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalytics.model.ReferenceDataSourceDescription = ReferenceDataSourceDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalytics.model.SourceSchema] inside the given [block]
         */
        public fun referenceSchema(block: aws.sdk.kotlin.services.kinesisanalytics.model.SourceSchema.Builder.() -> kotlin.Unit) {
            this.referenceSchema = aws.sdk.kotlin.services.kinesisanalytics.model.SourceSchema.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalytics.model.S3ReferenceDataSourceDescription] inside the given [block]
         */
        public fun s3ReferenceDataSourceDescription(block: aws.sdk.kotlin.services.kinesisanalytics.model.S3ReferenceDataSourceDescription.Builder.() -> kotlin.Unit) {
            this.s3ReferenceDataSourceDescription = aws.sdk.kotlin.services.kinesisanalytics.model.S3ReferenceDataSourceDescription.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (referenceId == null) referenceId = ""
            if (tableName == null) tableName = ""
            return this
        }
    }
}
