// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalytics.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * When updating application input configuration, provides information about an Amazon Kinesis stream as the streaming source.
 */
public class KinesisStreamsInputUpdate private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the input Amazon Kinesis stream to read.
     */
    public val resourceArnUpdate: kotlin.String? = builder.resourceArnUpdate
    /**
     * ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to grant the necessary permissions to this role.
     */
    public val roleArnUpdate: kotlin.String? = builder.roleArnUpdate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalytics.model.KinesisStreamsInputUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KinesisStreamsInputUpdate(")
        append("resourceArnUpdate=$resourceArnUpdate,")
        append("roleArnUpdate=$roleArnUpdate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceArnUpdate?.hashCode() ?: 0
        result = 31 * result + (this.roleArnUpdate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KinesisStreamsInputUpdate

        if (resourceArnUpdate != other.resourceArnUpdate) return false
        if (roleArnUpdate != other.roleArnUpdate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalytics.model.KinesisStreamsInputUpdate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the input Amazon Kinesis stream to read.
         */
        public var resourceArnUpdate: kotlin.String? = null
        /**
         * ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to grant the necessary permissions to this role.
         */
        public var roleArnUpdate: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalytics.model.KinesisStreamsInputUpdate) : this() {
            this.resourceArnUpdate = x.resourceArnUpdate
            this.roleArnUpdate = x.roleArnUpdate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalytics.model.KinesisStreamsInputUpdate = KinesisStreamsInputUpdate(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
