// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalytics.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Identifies an Amazon Kinesis Firehose delivery stream as the streaming source. You provide the delivery stream's Amazon Resource Name (ARN) and an IAM role ARN that enables Amazon Kinesis Analytics to access the stream on your behalf.
 */
public class KinesisFirehoseInput private constructor(builder: Builder) {
    /**
     * ARN of the input delivery stream.
     */
    public val resourceArn: kotlin.String = requireNotNull(builder.resourceArn) { "A non-null value must be provided for resourceArn" }
    /**
     * ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to make sure that the role has the necessary permissions to access the stream.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalytics.model.KinesisFirehoseInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KinesisFirehoseInput(")
        append("resourceArn=$resourceArn,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceArn.hashCode()
        result = 31 * result + (this.roleArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KinesisFirehoseInput

        if (resourceArn != other.resourceArn) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalytics.model.KinesisFirehoseInput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * ARN of the input delivery stream.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to make sure that the role has the necessary permissions to access the stream.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalytics.model.KinesisFirehoseInput) : this() {
            this.resourceArn = x.resourceArn
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalytics.model.KinesisFirehoseInput = KinesisFirehoseInput(this)

        internal fun correctErrors(): Builder {
            if (resourceArn == null) resourceArn = ""
            if (roleArn == null) roleArn = ""
            return this
        }
    }
}
