// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalytics.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * When you configure the application input, you specify the streaming source, the in-application stream name that is created, and the mapping between the two. For more information, see [Configuring Application Input](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
 */
public class Input private constructor(builder: Builder) {
    /**
     * Describes the number of in-application streams to create.
     *
     * Data from your source is routed to these in-application input streams.
     *
     *  (see [Configuring Application Input](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
     */
    public val inputParallelism: aws.sdk.kotlin.services.kinesisanalytics.model.InputParallelism? = builder.inputParallelism
    /**
     * The [InputProcessingConfiguration](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html) for the input. An input processor transforms records as they are received from the stream, before the application's SQL code executes. Currently, the only input processing configuration available is [InputLambdaProcessor](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessor.html).
     */
    public val inputProcessingConfiguration: aws.sdk.kotlin.services.kinesisanalytics.model.InputProcessingConfiguration? = builder.inputProcessingConfiguration
    /**
     * Describes the format of the data in the streaming source, and how each data element maps to corresponding columns in the in-application stream that is being created.
     *
     * Also used to describe the format of the reference data source.
     */
    public val inputSchema: aws.sdk.kotlin.services.kinesisanalytics.model.SourceSchema? = builder.inputSchema
    /**
     * If the streaming source is an Amazon Kinesis Firehose delivery stream, identifies the delivery stream's ARN and an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
     *
     * Note: Either `KinesisStreamsInput` or `KinesisFirehoseInput` is required.
     */
    public val kinesisFirehoseInput: aws.sdk.kotlin.services.kinesisanalytics.model.KinesisFirehoseInput? = builder.kinesisFirehoseInput
    /**
     * If the streaming source is an Amazon Kinesis stream, identifies the stream's Amazon Resource Name (ARN) and an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
     *
     * Note: Either `KinesisStreamsInput` or `KinesisFirehoseInput` is required.
     */
    public val kinesisStreamsInput: aws.sdk.kotlin.services.kinesisanalytics.model.KinesisStreamsInput? = builder.kinesisStreamsInput
    /**
     * Name prefix to use when creating an in-application stream. Suppose that you specify a prefix "MyInApplicationStream." Amazon Kinesis Analytics then creates one or more (as per the `InputParallelism` count you specified) in-application streams with names "MyInApplicationStream_001," "MyInApplicationStream_002," and so on.
     */
    public val namePrefix: kotlin.String = requireNotNull(builder.namePrefix) { "A non-null value must be provided for namePrefix" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalytics.model.Input = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Input(")
        append("inputParallelism=$inputParallelism,")
        append("inputProcessingConfiguration=$inputProcessingConfiguration,")
        append("inputSchema=$inputSchema,")
        append("kinesisFirehoseInput=$kinesisFirehoseInput,")
        append("kinesisStreamsInput=$kinesisStreamsInput,")
        append("namePrefix=$namePrefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = inputParallelism?.hashCode() ?: 0
        result = 31 * result + (this.inputProcessingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (this.inputSchema?.hashCode() ?: 0)
        result = 31 * result + (this.kinesisFirehoseInput?.hashCode() ?: 0)
        result = 31 * result + (this.kinesisStreamsInput?.hashCode() ?: 0)
        result = 31 * result + (this.namePrefix.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Input

        if (inputParallelism != other.inputParallelism) return false
        if (inputProcessingConfiguration != other.inputProcessingConfiguration) return false
        if (inputSchema != other.inputSchema) return false
        if (kinesisFirehoseInput != other.kinesisFirehoseInput) return false
        if (kinesisStreamsInput != other.kinesisStreamsInput) return false
        if (namePrefix != other.namePrefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalytics.model.Input = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Describes the number of in-application streams to create.
         *
         * Data from your source is routed to these in-application input streams.
         *
         *  (see [Configuring Application Input](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
         */
        public var inputParallelism: aws.sdk.kotlin.services.kinesisanalytics.model.InputParallelism? = null
        /**
         * The [InputProcessingConfiguration](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html) for the input. An input processor transforms records as they are received from the stream, before the application's SQL code executes. Currently, the only input processing configuration available is [InputLambdaProcessor](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessor.html).
         */
        public var inputProcessingConfiguration: aws.sdk.kotlin.services.kinesisanalytics.model.InputProcessingConfiguration? = null
        /**
         * Describes the format of the data in the streaming source, and how each data element maps to corresponding columns in the in-application stream that is being created.
         *
         * Also used to describe the format of the reference data source.
         */
        public var inputSchema: aws.sdk.kotlin.services.kinesisanalytics.model.SourceSchema? = null
        /**
         * If the streaming source is an Amazon Kinesis Firehose delivery stream, identifies the delivery stream's ARN and an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
         *
         * Note: Either `KinesisStreamsInput` or `KinesisFirehoseInput` is required.
         */
        public var kinesisFirehoseInput: aws.sdk.kotlin.services.kinesisanalytics.model.KinesisFirehoseInput? = null
        /**
         * If the streaming source is an Amazon Kinesis stream, identifies the stream's Amazon Resource Name (ARN) and an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
         *
         * Note: Either `KinesisStreamsInput` or `KinesisFirehoseInput` is required.
         */
        public var kinesisStreamsInput: aws.sdk.kotlin.services.kinesisanalytics.model.KinesisStreamsInput? = null
        /**
         * Name prefix to use when creating an in-application stream. Suppose that you specify a prefix "MyInApplicationStream." Amazon Kinesis Analytics then creates one or more (as per the `InputParallelism` count you specified) in-application streams with names "MyInApplicationStream_001," "MyInApplicationStream_002," and so on.
         */
        public var namePrefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalytics.model.Input) : this() {
            this.inputParallelism = x.inputParallelism
            this.inputProcessingConfiguration = x.inputProcessingConfiguration
            this.inputSchema = x.inputSchema
            this.kinesisFirehoseInput = x.kinesisFirehoseInput
            this.kinesisStreamsInput = x.kinesisStreamsInput
            this.namePrefix = x.namePrefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalytics.model.Input = Input(this)

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalytics.model.InputParallelism] inside the given [block]
         */
        public fun inputParallelism(block: aws.sdk.kotlin.services.kinesisanalytics.model.InputParallelism.Builder.() -> kotlin.Unit) {
            this.inputParallelism = aws.sdk.kotlin.services.kinesisanalytics.model.InputParallelism.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalytics.model.InputProcessingConfiguration] inside the given [block]
         */
        public fun inputProcessingConfiguration(block: aws.sdk.kotlin.services.kinesisanalytics.model.InputProcessingConfiguration.Builder.() -> kotlin.Unit) {
            this.inputProcessingConfiguration = aws.sdk.kotlin.services.kinesisanalytics.model.InputProcessingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalytics.model.SourceSchema] inside the given [block]
         */
        public fun inputSchema(block: aws.sdk.kotlin.services.kinesisanalytics.model.SourceSchema.Builder.() -> kotlin.Unit) {
            this.inputSchema = aws.sdk.kotlin.services.kinesisanalytics.model.SourceSchema.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalytics.model.KinesisFirehoseInput] inside the given [block]
         */
        public fun kinesisFirehoseInput(block: aws.sdk.kotlin.services.kinesisanalytics.model.KinesisFirehoseInput.Builder.() -> kotlin.Unit) {
            this.kinesisFirehoseInput = aws.sdk.kotlin.services.kinesisanalytics.model.KinesisFirehoseInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalytics.model.KinesisStreamsInput] inside the given [block]
         */
        public fun kinesisStreamsInput(block: aws.sdk.kotlin.services.kinesisanalytics.model.KinesisStreamsInput.Builder.() -> kotlin.Unit) {
            this.kinesisStreamsInput = aws.sdk.kotlin.services.kinesisanalytics.model.KinesisStreamsInput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (namePrefix == null) namePrefix = ""
            return this
        }
    }
}
