// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalytics.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes CloudWatch logging option updates.
 */
public class CloudWatchLoggingOptionUpdate private constructor(builder: Builder) {
    /**
     * ID of the CloudWatch logging option to update
     */
    public val cloudWatchLoggingOptionId: kotlin.String = requireNotNull(builder.cloudWatchLoggingOptionId) { "A non-null value must be provided for cloudWatchLoggingOptionId" }
    /**
     * ARN of the CloudWatch log to receive application messages.
     */
    public val logStreamArnUpdate: kotlin.String? = builder.logStreamArnUpdate
    /**
     * IAM ARN of the role to use to send application messages. Note: To write application messages to CloudWatch, the IAM role used must have the `PutLogEvents` policy action enabled.
     */
    public val roleArnUpdate: kotlin.String? = builder.roleArnUpdate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalytics.model.CloudWatchLoggingOptionUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CloudWatchLoggingOptionUpdate(")
        append("cloudWatchLoggingOptionId=$cloudWatchLoggingOptionId,")
        append("logStreamArnUpdate=$logStreamArnUpdate,")
        append("roleArnUpdate=$roleArnUpdate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLoggingOptionId.hashCode()
        result = 31 * result + (this.logStreamArnUpdate?.hashCode() ?: 0)
        result = 31 * result + (this.roleArnUpdate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CloudWatchLoggingOptionUpdate

        if (cloudWatchLoggingOptionId != other.cloudWatchLoggingOptionId) return false
        if (logStreamArnUpdate != other.logStreamArnUpdate) return false
        if (roleArnUpdate != other.roleArnUpdate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalytics.model.CloudWatchLoggingOptionUpdate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * ID of the CloudWatch logging option to update
         */
        public var cloudWatchLoggingOptionId: kotlin.String? = null
        /**
         * ARN of the CloudWatch log to receive application messages.
         */
        public var logStreamArnUpdate: kotlin.String? = null
        /**
         * IAM ARN of the role to use to send application messages. Note: To write application messages to CloudWatch, the IAM role used must have the `PutLogEvents` policy action enabled.
         */
        public var roleArnUpdate: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalytics.model.CloudWatchLoggingOptionUpdate) : this() {
            this.cloudWatchLoggingOptionId = x.cloudWatchLoggingOptionId
            this.logStreamArnUpdate = x.logStreamArnUpdate
            this.roleArnUpdate = x.roleArnUpdate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalytics.model.CloudWatchLoggingOptionUpdate = CloudWatchLoggingOptionUpdate(this)

        internal fun correctErrors(): Builder {
            if (cloudWatchLoggingOptionId == null) cloudWatchLoggingOptionId = ""
            return this
        }
    }
}
