// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalytics.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
 *
 * Provides a description of the application, including the application Amazon Resource Name (ARN), status, latest version, and input and output configuration.
 */
public class ApplicationDetail private constructor(builder: Builder) {
    /**
     * ARN of the application.
     */
    public val applicationArn: kotlin.String = requireNotNull(builder.applicationArn) { "A non-null value must be provided for applicationArn" }
    /**
     * Returns the application code that you provided to perform data analysis on any of the in-application streams in your application.
     */
    public val applicationCode: kotlin.String? = builder.applicationCode
    /**
     * Description of the application.
     */
    public val applicationDescription: kotlin.String? = builder.applicationDescription
    /**
     * Name of the application.
     */
    public val applicationName: kotlin.String = requireNotNull(builder.applicationName) { "A non-null value must be provided for applicationName" }
    /**
     * Status of the application.
     */
    public val applicationStatus: aws.sdk.kotlin.services.kinesisanalytics.model.ApplicationStatus = requireNotNull(builder.applicationStatus) { "A non-null value must be provided for applicationStatus" }
    /**
     * Provides the current application version.
     */
    public val applicationVersionId: kotlin.Long = requireNotNull(builder.applicationVersionId) { "A non-null value must be provided for applicationVersionId" }
    /**
     * Describes the CloudWatch log streams that are configured to receive application messages. For more information about using CloudWatch log streams with Amazon Kinesis Analytics applications, see [Working with Amazon CloudWatch Logs](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html).
     */
    public val cloudWatchLoggingOptionDescriptions: List<CloudWatchLoggingOptionDescription>? = builder.cloudWatchLoggingOptionDescriptions
    /**
     * Time stamp when the application version was created.
     */
    public val createTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createTimestamp
    /**
     * Describes the application input configuration. For more information, see [Configuring Application Input](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
     */
    public val inputDescriptions: List<InputDescription>? = builder.inputDescriptions
    /**
     * Time stamp when the application was last updated.
     */
    public val lastUpdateTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdateTimestamp
    /**
     * Describes the application output configuration. For more information, see [Configuring Application Output](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html).
     */
    public val outputDescriptions: List<OutputDescription>? = builder.outputDescriptions
    /**
     * Describes reference data sources configured for the application. For more information, see [Configuring Application Input](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
     */
    public val referenceDataSourceDescriptions: List<ReferenceDataSourceDescription>? = builder.referenceDataSourceDescriptions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalytics.model.ApplicationDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationDetail(")
        append("applicationArn=$applicationArn,")
        append("applicationCode=$applicationCode,")
        append("applicationDescription=$applicationDescription,")
        append("applicationName=$applicationName,")
        append("applicationStatus=$applicationStatus,")
        append("applicationVersionId=$applicationVersionId,")
        append("cloudWatchLoggingOptionDescriptions=$cloudWatchLoggingOptionDescriptions,")
        append("createTimestamp=$createTimestamp,")
        append("inputDescriptions=$inputDescriptions,")
        append("lastUpdateTimestamp=$lastUpdateTimestamp,")
        append("outputDescriptions=$outputDescriptions,")
        append("referenceDataSourceDescriptions=$referenceDataSourceDescriptions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationArn.hashCode()
        result = 31 * result + (this.applicationCode?.hashCode() ?: 0)
        result = 31 * result + (this.applicationDescription?.hashCode() ?: 0)
        result = 31 * result + (this.applicationName.hashCode())
        result = 31 * result + (this.applicationStatus.hashCode())
        result = 31 * result + (this.applicationVersionId.hashCode())
        result = 31 * result + (this.cloudWatchLoggingOptionDescriptions?.hashCode() ?: 0)
        result = 31 * result + (this.createTimestamp?.hashCode() ?: 0)
        result = 31 * result + (this.inputDescriptions?.hashCode() ?: 0)
        result = 31 * result + (this.lastUpdateTimestamp?.hashCode() ?: 0)
        result = 31 * result + (this.outputDescriptions?.hashCode() ?: 0)
        result = 31 * result + (this.referenceDataSourceDescriptions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApplicationDetail

        if (applicationArn != other.applicationArn) return false
        if (applicationCode != other.applicationCode) return false
        if (applicationDescription != other.applicationDescription) return false
        if (applicationName != other.applicationName) return false
        if (applicationStatus != other.applicationStatus) return false
        if (applicationVersionId != other.applicationVersionId) return false
        if (cloudWatchLoggingOptionDescriptions != other.cloudWatchLoggingOptionDescriptions) return false
        if (createTimestamp != other.createTimestamp) return false
        if (inputDescriptions != other.inputDescriptions) return false
        if (lastUpdateTimestamp != other.lastUpdateTimestamp) return false
        if (outputDescriptions != other.outputDescriptions) return false
        if (referenceDataSourceDescriptions != other.referenceDataSourceDescriptions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalytics.model.ApplicationDetail = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * ARN of the application.
         */
        public var applicationArn: kotlin.String? = null
        /**
         * Returns the application code that you provided to perform data analysis on any of the in-application streams in your application.
         */
        public var applicationCode: kotlin.String? = null
        /**
         * Description of the application.
         */
        public var applicationDescription: kotlin.String? = null
        /**
         * Name of the application.
         */
        public var applicationName: kotlin.String? = null
        /**
         * Status of the application.
         */
        public var applicationStatus: aws.sdk.kotlin.services.kinesisanalytics.model.ApplicationStatus? = null
        /**
         * Provides the current application version.
         */
        public var applicationVersionId: kotlin.Long? = null
        /**
         * Describes the CloudWatch log streams that are configured to receive application messages. For more information about using CloudWatch log streams with Amazon Kinesis Analytics applications, see [Working with Amazon CloudWatch Logs](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html).
         */
        public var cloudWatchLoggingOptionDescriptions: List<CloudWatchLoggingOptionDescription>? = null
        /**
         * Time stamp when the application version was created.
         */
        public var createTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Describes the application input configuration. For more information, see [Configuring Application Input](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
         */
        public var inputDescriptions: List<InputDescription>? = null
        /**
         * Time stamp when the application was last updated.
         */
        public var lastUpdateTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Describes the application output configuration. For more information, see [Configuring Application Output](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html).
         */
        public var outputDescriptions: List<OutputDescription>? = null
        /**
         * Describes reference data sources configured for the application. For more information, see [Configuring Application Input](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
         */
        public var referenceDataSourceDescriptions: List<ReferenceDataSourceDescription>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalytics.model.ApplicationDetail) : this() {
            this.applicationArn = x.applicationArn
            this.applicationCode = x.applicationCode
            this.applicationDescription = x.applicationDescription
            this.applicationName = x.applicationName
            this.applicationStatus = x.applicationStatus
            this.applicationVersionId = x.applicationVersionId
            this.cloudWatchLoggingOptionDescriptions = x.cloudWatchLoggingOptionDescriptions
            this.createTimestamp = x.createTimestamp
            this.inputDescriptions = x.inputDescriptions
            this.lastUpdateTimestamp = x.lastUpdateTimestamp
            this.outputDescriptions = x.outputDescriptions
            this.referenceDataSourceDescriptions = x.referenceDataSourceDescriptions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalytics.model.ApplicationDetail = ApplicationDetail(this)

        internal fun correctErrors(): Builder {
            if (applicationArn == null) applicationArn = ""
            if (applicationName == null) applicationName = ""
            if (applicationStatus == null) applicationStatus = ApplicationStatus.SdkUnknown("no value provided")
            if (applicationVersionId == null) applicationVersionId = 0L
            return this
        }
    }
}
