// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalytics.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes updates to the output configuration identified by the `OutputId`.
 */
public class OutputUpdate private constructor(builder: Builder) {
    /**
     * Describes the data format when records are written to the destination. For more information, see [Configuring Application Output](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html).
     */
    public val destinationSchemaUpdate: aws.sdk.kotlin.services.kinesisanalytics.model.DestinationSchema? = builder.destinationSchemaUpdate
    /**
     * Describes an Amazon Kinesis Firehose delivery stream as the destination for the output.
     */
    public val kinesisFirehoseOutputUpdate: aws.sdk.kotlin.services.kinesisanalytics.model.KinesisFirehoseOutputUpdate? = builder.kinesisFirehoseOutputUpdate
    /**
     * Describes an Amazon Kinesis stream as the destination for the output.
     */
    public val kinesisStreamsOutputUpdate: aws.sdk.kotlin.services.kinesisanalytics.model.KinesisStreamsOutputUpdate? = builder.kinesisStreamsOutputUpdate
    /**
     * Describes an AWS Lambda function as the destination for the output.
     */
    public val lambdaOutputUpdate: aws.sdk.kotlin.services.kinesisanalytics.model.LambdaOutputUpdate? = builder.lambdaOutputUpdate
    /**
     * If you want to specify a different in-application stream for this output configuration, use this field to specify the new in-application stream name.
     */
    public val nameUpdate: kotlin.String? = builder.nameUpdate
    /**
     * Identifies the specific output configuration that you want to update.
     */
    public val outputId: kotlin.String = requireNotNull(builder.outputId) { "A non-null value must be provided for outputId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalytics.model.OutputUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OutputUpdate(")
        append("destinationSchemaUpdate=$destinationSchemaUpdate,")
        append("kinesisFirehoseOutputUpdate=$kinesisFirehoseOutputUpdate,")
        append("kinesisStreamsOutputUpdate=$kinesisStreamsOutputUpdate,")
        append("lambdaOutputUpdate=$lambdaOutputUpdate,")
        append("nameUpdate=$nameUpdate,")
        append("outputId=$outputId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationSchemaUpdate?.hashCode() ?: 0
        result = 31 * result + (kinesisFirehoseOutputUpdate?.hashCode() ?: 0)
        result = 31 * result + (kinesisStreamsOutputUpdate?.hashCode() ?: 0)
        result = 31 * result + (lambdaOutputUpdate?.hashCode() ?: 0)
        result = 31 * result + (nameUpdate?.hashCode() ?: 0)
        result = 31 * result + (outputId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OutputUpdate

        if (destinationSchemaUpdate != other.destinationSchemaUpdate) return false
        if (kinesisFirehoseOutputUpdate != other.kinesisFirehoseOutputUpdate) return false
        if (kinesisStreamsOutputUpdate != other.kinesisStreamsOutputUpdate) return false
        if (lambdaOutputUpdate != other.lambdaOutputUpdate) return false
        if (nameUpdate != other.nameUpdate) return false
        if (outputId != other.outputId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalytics.model.OutputUpdate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Describes the data format when records are written to the destination. For more information, see [Configuring Application Output](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html).
         */
        public var destinationSchemaUpdate: aws.sdk.kotlin.services.kinesisanalytics.model.DestinationSchema? = null
        /**
         * Describes an Amazon Kinesis Firehose delivery stream as the destination for the output.
         */
        public var kinesisFirehoseOutputUpdate: aws.sdk.kotlin.services.kinesisanalytics.model.KinesisFirehoseOutputUpdate? = null
        /**
         * Describes an Amazon Kinesis stream as the destination for the output.
         */
        public var kinesisStreamsOutputUpdate: aws.sdk.kotlin.services.kinesisanalytics.model.KinesisStreamsOutputUpdate? = null
        /**
         * Describes an AWS Lambda function as the destination for the output.
         */
        public var lambdaOutputUpdate: aws.sdk.kotlin.services.kinesisanalytics.model.LambdaOutputUpdate? = null
        /**
         * If you want to specify a different in-application stream for this output configuration, use this field to specify the new in-application stream name.
         */
        public var nameUpdate: kotlin.String? = null
        /**
         * Identifies the specific output configuration that you want to update.
         */
        public var outputId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalytics.model.OutputUpdate) : this() {
            this.destinationSchemaUpdate = x.destinationSchemaUpdate
            this.kinesisFirehoseOutputUpdate = x.kinesisFirehoseOutputUpdate
            this.kinesisStreamsOutputUpdate = x.kinesisStreamsOutputUpdate
            this.lambdaOutputUpdate = x.lambdaOutputUpdate
            this.nameUpdate = x.nameUpdate
            this.outputId = x.outputId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalytics.model.OutputUpdate = OutputUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalytics.model.DestinationSchema] inside the given [block]
         */
        public fun destinationSchemaUpdate(block: aws.sdk.kotlin.services.kinesisanalytics.model.DestinationSchema.Builder.() -> kotlin.Unit) {
            this.destinationSchemaUpdate = aws.sdk.kotlin.services.kinesisanalytics.model.DestinationSchema.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalytics.model.KinesisFirehoseOutputUpdate] inside the given [block]
         */
        public fun kinesisFirehoseOutputUpdate(block: aws.sdk.kotlin.services.kinesisanalytics.model.KinesisFirehoseOutputUpdate.Builder.() -> kotlin.Unit) {
            this.kinesisFirehoseOutputUpdate = aws.sdk.kotlin.services.kinesisanalytics.model.KinesisFirehoseOutputUpdate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalytics.model.KinesisStreamsOutputUpdate] inside the given [block]
         */
        public fun kinesisStreamsOutputUpdate(block: aws.sdk.kotlin.services.kinesisanalytics.model.KinesisStreamsOutputUpdate.Builder.() -> kotlin.Unit) {
            this.kinesisStreamsOutputUpdate = aws.sdk.kotlin.services.kinesisanalytics.model.KinesisStreamsOutputUpdate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalytics.model.LambdaOutputUpdate] inside the given [block]
         */
        public fun lambdaOutputUpdate(block: aws.sdk.kotlin.services.kinesisanalytics.model.LambdaOutputUpdate.Builder.() -> kotlin.Unit) {
            this.lambdaOutputUpdate = aws.sdk.kotlin.services.kinesisanalytics.model.LambdaOutputUpdate.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (outputId == null) outputId = ""
            return this
        }
    }
}
