// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalytics.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents an update to the [InputLambdaProcessor](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessor.html) that is used to preprocess the records in the stream.
 */
public class InputLambdaProcessorUpdate private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the new [AWS Lambda](https://docs.aws.amazon.com/lambda/) function that is used to preprocess the records in the stream.
     *
     * To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see [Example ARNs: AWS Lambda](/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
     */
    public val resourceArnUpdate: kotlin.String? = builder.resourceArnUpdate
    /**
     * The ARN of the new IAM role that is used to access the AWS Lambda function.
     */
    public val roleArnUpdate: kotlin.String? = builder.roleArnUpdate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalytics.model.InputLambdaProcessorUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InputLambdaProcessorUpdate(")
        append("resourceArnUpdate=$resourceArnUpdate,")
        append("roleArnUpdate=$roleArnUpdate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceArnUpdate?.hashCode() ?: 0
        result = 31 * result + (roleArnUpdate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InputLambdaProcessorUpdate

        if (resourceArnUpdate != other.resourceArnUpdate) return false
        if (roleArnUpdate != other.roleArnUpdate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalytics.model.InputLambdaProcessorUpdate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the new [AWS Lambda](https://docs.aws.amazon.com/lambda/) function that is used to preprocess the records in the stream.
         *
         * To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see [Example ARNs: AWS Lambda](/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
         */
        public var resourceArnUpdate: kotlin.String? = null
        /**
         * The ARN of the new IAM role that is used to access the AWS Lambda function.
         */
        public var roleArnUpdate: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalytics.model.InputLambdaProcessorUpdate) : this() {
            this.resourceArnUpdate = x.resourceArnUpdate
            this.roleArnUpdate = x.roleArnUpdate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalytics.model.InputLambdaProcessorUpdate = InputLambdaProcessorUpdate(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
