// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.kinesis.model.ChildShard
import aws.sdk.kotlin.services.kinesis.model.GetRecordsResponse
import aws.sdk.kotlin.services.kinesis.model.KinesisException
import aws.sdk.kotlin.services.kinesis.model.Record
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetRecordsOperationDeserializer: HttpDeserialize<GetRecordsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetRecordsResponse {
        if (!response.status.isSuccess()) {
            throwGetRecordsError(context, response)
        }
        val builder = GetRecordsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetRecordsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetRecordsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KinesisException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "KMSAccessDeniedException" -> KmsAccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSDisabledException" -> KmsDisabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSNotFoundException" -> KmsNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ExpiredIteratorException" -> ExpiredIteratorExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSOptInRequired" -> KmsOptInRequiredDeserializer().deserialize(context, wrappedResponse)
        "KMSThrottlingException" -> KmsThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ProvisionedThroughputExceededException" -> ProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSInvalidStateException" -> KmsInvalidStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KinesisException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRecordsOperationBody(builder: GetRecordsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CHILDSHARDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ChildShards"))
    val MILLISBEHINDLATEST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("MillisBehindLatest"))
    val NEXTSHARDITERATOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextShardIterator"))
    val RECORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Records"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHILDSHARDS_DESCRIPTOR)
        field(MILLISBEHINDLATEST_DESCRIPTOR)
        field(NEXTSHARDITERATOR_DESCRIPTOR)
        field(RECORDS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHILDSHARDS_DESCRIPTOR.index -> builder.childShards =
                    deserializer.deserializeList(CHILDSHARDS_DESCRIPTOR) {
                        val col0 = mutableListOf<ChildShard>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeChildShardDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MILLISBEHINDLATEST_DESCRIPTOR.index -> builder.millisBehindLatest = deserializeLong()
                NEXTSHARDITERATOR_DESCRIPTOR.index -> builder.nextShardIterator = deserializeString()
                RECORDS_DESCRIPTOR.index -> builder.records =
                    deserializer.deserializeList(RECORDS_DESCRIPTOR) {
                        val col0 = mutableListOf<Record>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRecordDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
