// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The request parameter used to filter out the response of the `ListShards` API.
 */
public class ShardFilter private constructor(builder: Builder) {
    /**
     * The exclusive start `shardID` speified in the `ShardFilter` parameter. This property can only be used if the `AFTER_SHARD_ID` shard type is specified.
     */
    public val shardId: kotlin.String? = builder.shardId
    /**
     * The timestamps specified in the `ShardFilter` parameter. A timestamp is a Unix epoch date with precision in milliseconds. For example, 2016-04-04T19:58:46.480-00:00 or 1459799926.480. This property can only be used if `FROM_TIMESTAMP` or `AT_TIMESTAMP` shard types are specified.
     */
    public val timestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.timestamp
    /**
     * The shard type specified in the `ShardFilter` parameter. This is a required property of the `ShardFilter` parameter.
     *
     * You can specify the following valid values:
     * + `AFTER_SHARD_ID` - the response includes all the shards, starting with the shard whose ID immediately follows the `ShardId` that you provided.
     * + `AT_TRIM_HORIZON` - the response includes all the shards that were open at `TRIM_HORIZON`.
     * + `FROM_TRIM_HORIZON` - (default), the response includes all the shards within the retention period of the data stream (trim to tip).
     * + `AT_LATEST` - the response includes only the currently open shards of the data stream.
     * + `AT_TIMESTAMP` - the response includes all shards whose start timestamp is less than or equal to the given timestamp and end timestamp is greater than or equal to the given timestamp or still open.
     * + `FROM_TIMESTAMP` - the response incldues all closed shards whose end timestamp is greater than or equal to the given timestamp and also all open shards. Corrected to `TRIM_HORIZON` of the data stream if `FROM_TIMESTAMP` is less than the `TRIM_HORIZON` value.
     */
    public val type: aws.sdk.kotlin.services.kinesis.model.ShardFilterType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesis.model.ShardFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ShardFilter(")
        append("shardId=$shardId,")
        append("timestamp=$timestamp,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = shardId?.hashCode() ?: 0
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ShardFilter

        if (shardId != other.shardId) return false
        if (timestamp != other.timestamp) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesis.model.ShardFilter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The exclusive start `shardID` speified in the `ShardFilter` parameter. This property can only be used if the `AFTER_SHARD_ID` shard type is specified.
         */
        public var shardId: kotlin.String? = null
        /**
         * The timestamps specified in the `ShardFilter` parameter. A timestamp is a Unix epoch date with precision in milliseconds. For example, 2016-04-04T19:58:46.480-00:00 or 1459799926.480. This property can only be used if `FROM_TIMESTAMP` or `AT_TIMESTAMP` shard types are specified.
         */
        public var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The shard type specified in the `ShardFilter` parameter. This is a required property of the `ShardFilter` parameter.
         *
         * You can specify the following valid values:
         * + `AFTER_SHARD_ID` - the response includes all the shards, starting with the shard whose ID immediately follows the `ShardId` that you provided.
         * + `AT_TRIM_HORIZON` - the response includes all the shards that were open at `TRIM_HORIZON`.
         * + `FROM_TRIM_HORIZON` - (default), the response includes all the shards within the retention period of the data stream (trim to tip).
         * + `AT_LATEST` - the response includes only the currently open shards of the data stream.
         * + `AT_TIMESTAMP` - the response includes all shards whose start timestamp is less than or equal to the given timestamp and end timestamp is greater than or equal to the given timestamp or still open.
         * + `FROM_TIMESTAMP` - the response incldues all closed shards whose end timestamp is greater than or equal to the given timestamp and also all open shards. Corrected to `TRIM_HORIZON` of the data stream if `FROM_TIMESTAMP` is less than the `TRIM_HORIZON` value.
         */
        public var type: aws.sdk.kotlin.services.kinesis.model.ShardFilterType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesis.model.ShardFilter) : this() {
            this.shardId = x.shardId
            this.timestamp = x.timestamp
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesis.model.ShardFilter = ShardFilter(this)
    }
}
